/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portletbridge.application.PortletViewState;
import org.jboss.portletbridge.context.PortletApplicationScopeSessionMap;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.context.ServletApplicationScopeSessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletELResolver
extends ELResolver {
    public static final String PORTLET_CONFIG = "portletConfig";
    public static final String SESSION_APPLICATION_SCOPE = "sessionApplicationScope";
    public static final String SESSION_PORTLET_SCOPE = "sessionPortletScope";
    public static final String PORTLET_PREFERENCE_VALUE = "portletPreferenceValue";
    public static final String PORTLET_PREFERENCE_VALUES = "portletPreferenceValues";
    private Map<String, Object> mAppScopeSessionMap = null;

    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ExternalContext extCtx = facesContext.getExternalContext();
        Bridge.PortletPhase phase = (Bridge.PortletPhase)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        if (phase == null) {
            return null;
        }
        if (PORTLET_CONFIG.equals(property)) {
            context.setPropertyResolved(true);
            return context.getContext(PortletConfig.class);
        }
        if (SESSION_APPLICATION_SCOPE.equals(property)) {
            context.setPropertyResolved(true);
            if (this.mAppScopeSessionMap == null) {
                Object request = extCtx.getRequest();
                Object portletLifecycleAttr = extCtx.getRequestMap().get("javax.portlet.faces.phase");
                if (null == portletLifecycleAttr) {
                    this.mAppScopeSessionMap = new ServletApplicationScopeSessionMap((HttpServletRequest)request);
                } else if (portletLifecycleAttr instanceof Bridge.PortletPhase) {
                    this.mAppScopeSessionMap = new PortletApplicationScopeSessionMap((PortletRequest)request);
                }
            }
            return this.mAppScopeSessionMap;
        }
        if (SESSION_PORTLET_SCOPE.equals(property)) {
            context.setPropertyResolved(true);
            return extCtx.getSessionMap();
        }
        if (PORTLET_PREFERENCE_VALUE.equals(property)) {
            context.setPropertyResolved(true);
            return this.getPreferencesValueMap(facesContext);
        }
        if (PORTLET_PREFERENCE_VALUES.equals(property)) {
            context.setPropertyResolved(true);
            return this.getPreferencesValuesMap(facesContext);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) throws ELException {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        if (base != null) {
            return false;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(14);
        list.add(this.getFeatureDescriptor(PORTLET_CONFIG, PORTLET_CONFIG, PORTLET_CONFIG, false, false, true, Object.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(SESSION_APPLICATION_SCOPE, SESSION_APPLICATION_SCOPE, SESSION_APPLICATION_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(SESSION_PORTLET_SCOPE, SESSION_PORTLET_SCOPE, SESSION_PORTLET_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCE_VALUE, PORTLET_PREFERENCE_VALUE, PORTLET_PREFERENCE_VALUE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCE_VALUES, PORTLET_PREFERENCE_VALUES, PORTLET_PREFERENCE_VALUES, false, false, true, Map.class, Boolean.TRUE));
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    private Map getPreferencesValuesMap(FacesContext context) {
        if (PortletELResolver.isPortletRequest()) {
            return ((PortletRequest)context.getExternalContext().getRequest()).getPreferences().getMap();
        }
        PortletBridgeContext bridgeContext = (PortletBridgeContext)context.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME);
        Map<Object, Object> portletPreferencesMap = Collections.emptyMap();
        if (null != bridgeContext) {
            PortletViewState windowState = bridgeContext.getViewState();
            portletPreferencesMap = windowState.getPortletPreferencesMap();
        }
        return portletPreferencesMap;
    }

    private Map<String, String> getPreferencesValueMap(FacesContext context) {
        HashMap<String, String> m = new HashMap<String, String>();
        Map preferencesValuesMap = this.getPreferencesValuesMap(context);
        for (Map.Entry entry : preferencesValuesMap.entrySet()) {
            String[] preferenceValues = (String[])entry.getValue();
            if (null == preferenceValues || preferenceValues.length <= 0) continue;
            m.put((String)entry.getKey(), preferenceValues[0]);
        }
        return Collections.unmodifiableMap(m);
    }

    public static boolean isPortletRequest() {
        Map m = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        Bridge.PortletPhase phase = (Bridge.PortletPhase)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        return phase != null;
    }
}

