/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.lifecycle;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;
import org.ajax4jsf.context.AjaxContext;
import org.jboss.portletbridge.application.PortletStateHolder;
import org.jboss.portletbridge.application.PortletViewState;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;

public class PortalPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4023885603543145666L;

    public void afterPhase(PhaseEvent event) {
        PortletBridgeContext bridgeContext;
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        Object portletPhase = context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        PortletViewState windowState = null;
        if (portletPhase instanceof Bridge.PortletPhase && null != (bridgeContext = (PortletBridgeContext)context.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME))) {
            windowState = bridgeContext.getViewState();
        }
        if (phaseId.equals(PhaseId.RESTORE_VIEW)) {
            if (Bridge.PortletPhase.RenderPhase.equals(portletPhase)) {
                context.renderResponse();
            }
        } else if (phaseId.equals(PhaseId.RENDER_RESPONSE)) {
            if (null != windowState) {
                windowState.saveSeamConversationId(context);
            }
        } else if ((phaseId.equals(PhaseId.INVOKE_APPLICATION) || context.getRenderResponse() || context.getResponseComplete()) && null != windowState && Bridge.PortletPhase.ActionPhase.equals(portletPhase)) {
            windowState.saveSeamConversationId(context);
        }
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        Object portletPhase = context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        if (null == portletPhase && phaseId.equals(PhaseId.RENDER_RESPONSE)) {
            PortalActionURL pal;
            PortletViewState windowState;
            Map requestParameters = context.getExternalContext().getRequestParameterMap();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            Map commonAjaxParameters = ajaxContext.getCommonAjaxParameters();
            String stateId = (String)requestParameters.get("javax.faces.portletbridge.STATE_ID");
            try {
                windowState = PortletStateHolder.getInstance(context).getWindowState(stateId);
            }
            catch (BridgeException e) {
                if (context.getExternalContext().getRequest() instanceof PortletRequest) {
                    throw e;
                }
                windowState = null;
            }
            if (null != windowState && null != (pal = windowState.getPortalActionURL())) {
                pal.addParameter("org.jboss.portletbridge.VIEWID", context.getViewRoot().getViewId());
            }
            commonAjaxParameters.put("javax.faces.portletbridge.STATE_ID", stateId);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

