/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.StringReader;
import java.util.List;
import org.jboss.portletbridge.util.StateHandler;
import org.jboss.portletbridge.util.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigHandler
extends DefaultHandler {
    private static final String JEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final String BRIDGE_NS = "http://www.apache.org/myfaces/xml/ns/bridge/bridge-extension";
    private static final String APPLICATION_ELEMENT = "application";
    private static final String APP_EXTENSION_ELEMENT = "application-extension";
    private static final String EXCLUDED_ATTRIBUTES_ELEMENT = "excluded-attributes";
    private static final String EXCLUDED_ATTRIBUTE_ELEMENT = "excluded-attribute";
    private List<String> excludedAttributes;
    private XMLReader reader;

    public FacesConfigHandler(XMLReader reader, List<String> excludedAttributes) {
        this.reader = reader;
        this.excludedAttributes = excludedAttributes;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (APPLICATION_ELEMENT.equals(localName) && JEE_NS.equals(uri)) {
            this.reader.setContentHandler(new ApplicationHandler());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    private class ExcludedAttributeHandler
    extends StringContentHandler {
        public ExcludedAttributeHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent, new StringBuilder());
        }

        protected void endLastElement() {
            FacesConfigHandler.this.excludedAttributes.add(this.getResult().toString());
        }
    }

    private class ExcludedAttributesHandler
    extends StateHandler {
        public ExcludedAttributesHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName) && FacesConfigHandler.BRIDGE_NS.equals(uri)) {
                return new ExcludedAttributeHandler((ContentHandler)this);
            }
            return null;
        }
    }

    private class ApplicationExtensionHandler
    extends StateHandler {
        public ApplicationExtensionHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName) && FacesConfigHandler.BRIDGE_NS.equals(uri)) {
                return new ExcludedAttributesHandler((ContentHandler)this);
            }
            return null;
        }
    }

    private class ApplicationHandler
    extends StateHandler {
        public ApplicationHandler() {
            super(FacesConfigHandler.this.reader, FacesConfigHandler.this);
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.APP_EXTENSION_ELEMENT.equals(localName) && FacesConfigHandler.JEE_NS.equals(uri)) {
                return new ApplicationExtensionHandler((ContentHandler)this);
            }
            return null;
        }
    }
}

