/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.portletbridge.util.ServletBean;
import org.jboss.portletbridge.util.ServletMapping;
import org.jboss.portletbridge.util.StateHandler;
import org.jboss.portletbridge.util.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WebappHandler
extends DefaultHandler {
    private static final String SERVLET_MAPPING_ELEMENT = "servlet-mapping";
    private static final String SERVLET_ELEMENT = "servlet";
    static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    private List<ServletBean> servlets = new ArrayList<ServletBean>();
    private List<ServletMapping> mappings = new ArrayList<ServletMapping>();
    private ServletBean facesServlet;
    private XMLReader xmlReader;
    static final String URL_PATTERN_ELEMENT = "url-pattern";
    static final String SERVLET_NAME_ELEMENT = "servlet-name";
    static final String SERVLET_CLASS_ELEMENT = "servlet-class";

    public WebappHandler(XMLReader reader, ServletBean bean) {
        this.xmlReader = reader;
        this.facesServlet = bean;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (SERVLET_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new ServletHandler());
        } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new MappingHandler());
        }
    }

    public void endDocument() throws SAXException {
        for (ServletBean servlet : this.servlets) {
            if (!FACES_SERVLET_CLASS.equals(servlet.getClassName())) continue;
            this.facesServlet.setName(servlet.getName());
            this.facesServlet.setClassName(servlet.getClassName());
            for (ServletMapping mapping : this.mappings) {
                if (!servlet.getName().equals(mapping.getServletName())) continue;
                this.facesServlet.getMappings().add(mapping.getUrlPattern());
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    final class MappingHandler
    extends StateHandler {
        private StringBuilder servletName;
        private StringBuilder urlPattern;

        public MappingHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.servletName = new StringBuilder();
            this.urlPattern = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.URL_PATTERN_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.urlPattern);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.mappings.add(new ServletMapping(this.servletName.toString().trim(), this.urlPattern.toString().trim()));
        }
    }

    final class ServletHandler
    extends StateHandler {
        private StringBuilder servletName;
        private StringBuilder servletClass;

        public ServletHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.servletName = new StringBuilder();
            this.servletClass = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.SERVLET_CLASS_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletClass);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.servlets.add(new ServletBean(this.servletName.toString().trim(), this.servletClass.toString().trim()));
        }
    }
}

