/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import org.jboss.remoting.util.SecurityUtility;

public class Version {
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    public static final byte VERSION_2_2 = 22;
    public static final String VERSION = "2.5.0.GA (Flounder)";
    private static final byte byteVersion = 22;
    private static byte defaultByteVersion = (byte)22;
    private static boolean performVersioning = true;
    public static final String PRE_2_0_COMPATIBLE = "jboss.remoting.pre_2_0_compatible";
    public static final String REMOTING_VERSION_TO_USE = "jboss.remoting.version";

    public static void main(String[] arg) {
        System.out.println("JBossRemoting Version 2.5.0.GA (Flounder)");
    }

    public static int getDefaultVersion() {
        return defaultByteVersion;
    }

    public static boolean performVersioning() {
        return performVersioning;
    }

    public static boolean performVersioning(int version) {
        return version >= 2;
    }

    public static boolean isValidVersion(int version) {
        return version == 1 || version == 2 || version == 22;
    }

    static {
        boolean precompatibleFlag = false;
        String precompatible = SecurityUtility.getSystemProperty(PRE_2_0_COMPATIBLE);
        if (precompatible != null && precompatible.length() > 0) {
            precompatibleFlag = Boolean.valueOf(precompatible);
        }
        if (precompatibleFlag) {
            defaultByteVersion = 1;
            performVersioning = false;
        } else {
            String userDefinedVersion = SecurityUtility.getSystemProperty(REMOTING_VERSION_TO_USE);
            if (userDefinedVersion != null && userDefinedVersion.length() > 0) {
                byte userByteVersion = new Byte(userDefinedVersion);
                if (userByteVersion > 0) {
                    defaultByteVersion = userByteVersion;
                    if (defaultByteVersion < 2) {
                        performVersioning = false;
                    }
                } else {
                    System.err.println("Can not set remoting version to value less than 1.  System property value set for 'jboss.remoting.version' was " + userDefinedVersion);
                }
            } else {
                SecurityUtility.setSystemProperty(REMOTING_VERSION_TO_USE, new Byte(defaultByteVersion).toString());
            }
        }
    }
}

