/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLSession;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.ProtocolException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceOpenException;
import org.jboss.remoting3.remote.Equaller;
import org.jboss.remoting3.remote.IntIndexHashMap;
import org.jboss.remoting3.remote.IntIndexMap;
import org.jboss.remoting3.remote.PendingChannel;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pooled;
import org.xnio.Result;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.SuspendableReadChannel;

final class RemoteConnectionHandler
extends AbstractHandleableCloseable<ConnectionHandler>
implements ConnectionHandler {
    private final ConnectionHandlerContext connectionContext;
    private final RemoteConnection remoteConnection;
    private final IntIndexMap<RemoteConnectionChannel> channels = new IntIndexHashMap<Object>(RemoteConnectionChannel.INDEXER, Equaller.IDENTITY);
    private final IntIndexMap<PendingChannel> pendingChannels = new IntIndexHashMap<Object>(PendingChannel.INDEXER, Equaller.IDENTITY);
    private final Collection<Principal> principals;
    private final UserInfo userInfo;
    private final int maxInboundChannels;
    private final int maxOutboundChannels;
    private final String remoteEndpointName;
    private final int behavior;
    private volatile int channelState = 0;
    private static final AtomicIntegerFieldUpdater<RemoteConnectionHandler> channelStateUpdater = AtomicIntegerFieldUpdater.newUpdater(RemoteConnectionHandler.class, "channelState");
    private static final int SENT_CLOSE_REQ = Integer.MIN_VALUE;
    private static final int RECEIVED_CLOSE_REQ = 0x40000000;
    private static final int OUTBOUND_CHANNELS_MASK = Short.MAX_VALUE;
    private static final int ONE_OUTBOUND_CHANNEL = 1;
    private static final int INBOUND_CHANNELS_MASK = 1073709056;
    private static final int ONE_INBOUND_CHANNEL = 32768;

    RemoteConnectionHandler(ConnectionHandlerContext connectionContext, RemoteConnection remoteConnection, Collection<Principal> principals, UserInfo userInfo, int maxInboundChannels, int maxOutboundChannels, String remoteEndpointName, int behavior) {
        super(remoteConnection.getExecutor());
        this.connectionContext = connectionContext;
        this.remoteConnection = remoteConnection;
        this.maxInboundChannels = maxInboundChannels;
        this.maxOutboundChannels = maxOutboundChannels;
        this.remoteEndpointName = remoteEndpointName;
        this.behavior = behavior;
        this.principals = Collections.unmodifiableCollection(principals);
        this.userInfo = userInfo;
    }

    void handleConnectionClose() {
        this.remoteConnection.shutdownWrites();
        this.closePendingChannels();
        this.closeAllChannels();
    }

    @Override
    protected void closeComplete() {
        super.closeComplete();
        this.remoteConnection.getRemoteConnectionProvider().removeConnectionHandler(this);
    }

    void handleChannelClosed(RemoteConnectionChannel channel) {
        boolean inbound;
        int channelId = channel.getChannelId();
        this.channels.remove(channel);
        boolean bl = inbound = (channelId & Integer.MIN_VALUE) == 0;
        if (inbound) {
            this.handleInboundChannelClosed();
        } else {
            this.handleOutboundChannelClosed();
        }
    }

    void handleInboundChannelClosed() {
        int oldState = this.incrementState(Short.MIN_VALUE);
        if (oldState == -1073741824) {
            RemoteLogger.log.tracef("Closed inbound channel on %s (shutting down)", this);
            this.remoteConnection.shutdownWrites();
        } else {
            RemoteLogger.log.tracef("Closed inbound channel on %s", this);
        }
    }

    void handleOutboundChannelClosed() {
        int oldState = this.incrementState(-1);
        if (oldState == -1073741824) {
            RemoteLogger.log.tracef("Closed outbound channel on %s (shutting down)", this);
            this.remoteConnection.shutdownWrites();
        } else {
            RemoteLogger.log.tracef("Closed outbound channel on %s", this);
        }
    }

    boolean handleInboundChannelOpen() {
        int newState;
        int oldState;
        do {
            int oldCount;
            if ((oldCount = (oldState = this.channelState) & 0x3FFF8000) == this.maxInboundChannels) {
                RemoteLogger.log.tracef("Refused inbound channel request on %s because too many inbound channels are open", this);
                return false;
            }
            if ((oldState & Integer.MIN_VALUE) == 0) continue;
            RemoteLogger.log.tracef("Refused inbound channel request on %s because close request was sent", this);
            return false;
        } while (!this.casState(oldState, newState = oldState + 32768));
        RemoteLogger.log.tracef("Opened inbound channel on %s", this);
        return true;
    }

    void handleOutboundChannelOpen() throws IOException {
        int newState;
        int oldState;
        do {
            int oldCount;
            if ((oldCount = (oldState = this.channelState) & Short.MAX_VALUE) == this.maxOutboundChannels) {
                RemoteLogger.log.tracef("Refused outbound channel open on %s because too many outbound channels are open", this);
                throw new ProtocolException("Too many channels open");
            }
            if ((oldState & Integer.MIN_VALUE) == 0) continue;
            RemoteLogger.log.tracef("Refused outbound channel open on %s because close request was sent", this);
            throw new NotOpenException("Cannot open new channel because close was initiated");
        } while (!this.casState(oldState, newState = oldState + 1));
        RemoteLogger.log.tracef("Opened outbound channel on %s", this);
    }

    void receiveCloseRequest() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & 0x40000000) == 0) continue;
            return;
        } while (!this.casState(oldState, newState = oldState | 0x40000000 | Integer.MIN_VALUE));
        this.closePendingChannels();
        RemoteLogger.log.tracef("Received remote close request on %s", this);
        if ((oldState & Integer.MIN_VALUE) == 0) {
            this.sendCloseRequestBody();
            this.closeAllChannels();
        }
        if ((oldState & 0x3FFFFFFF) == 0) {
            this.remoteConnection.shutdownWrites();
        }
    }

    void sendCloseRequest() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & Integer.MIN_VALUE) == 0) continue;
            return;
        } while (!this.casState(oldState, newState = oldState | Integer.MIN_VALUE));
        RemoteLogger.log.tracef("Sending close request on %s", this);
        this.sendCloseRequestBody();
        this.closeAllChannels();
        if ((oldState & 0x3FFFFFFF) == 0) {
            this.remoteConnection.shutdownWrites();
        }
    }

    private int incrementState(int count) {
        int oldState = channelStateUpdater.getAndAdd(this, count);
        if (RemoteLogger.log.isTraceEnabled()) {
            int newState = oldState + count;
            RemoteLogger.log.tracef("CAS %s\n\told: RS=%s WS=%s IC=%d OC=%d\n\tnew: RS=%s WS=%s IC=%d OC=%d", new Object[]{this, (oldState & 0x40000000) != 0, (oldState & Integer.MIN_VALUE) != 0, (oldState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (oldState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1), (newState & 0x40000000) != 0, (newState & Integer.MIN_VALUE) != 0, (newState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (newState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1)});
        }
        return oldState;
    }

    private boolean casState(int oldState, int newState) {
        boolean result = channelStateUpdater.compareAndSet(this, oldState, newState);
        if (result && RemoteLogger.log.isTraceEnabled()) {
            RemoteLogger.log.tracef("CAS %s\n\told: RS=%s WS=%s IC=%d OC=%d\n\tnew: RS=%s WS=%s IC=%d OC=%d", new Object[]{this, (oldState & 0x40000000) != 0, (oldState & Integer.MIN_VALUE) != 0, (oldState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (oldState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1), (newState & 0x40000000) != 0, (newState & Integer.MIN_VALUE) != 0, (newState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (newState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1)});
        }
        return result;
    }

    private void sendCloseRequestBody() {
        RemoteConnectionHandler.sendCloseRequestBody(this.remoteConnection);
        RemoteLogger.log.tracef("Sent close request on %s", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendCloseRequestBody(RemoteConnection remoteConnection) {
        Pooled<ByteBuffer> pooled = remoteConnection.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.put((byte)-1);
            buffer.flip();
            remoteConnection.send(pooled, true);
            ok = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable open(String serviceType, Result<Channel> result, OptionMap optionMap) {
        RemoteLogger.log.tracef("Requesting service open of type %s on %s", serviceType, this);
        byte[] serviceTypeBytes = serviceType.getBytes(Protocol.UTF_8);
        int serviceTypeLength = serviceTypeBytes.length;
        if (serviceTypeLength > 255) {
            RemoteLogger.log.tracef("Rejecting service open of type %s on %s due to service type name being too long", serviceType, this);
            result.setException((IOException)new ServiceOpenException("Service type name is too long"));
            return IoUtils.nullCancellable();
        }
        OptionMap connectionOptionMap = this.remoteConnection.getOptionMap();
        int outboundWindowSizeOptionValue = connectionOptionMap.get(RemotingOptions.TRANSMIT_WINDOW_SIZE, Integer.MAX_VALUE);
        int outboundMessageCountOptionValue = connectionOptionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGES, 65535);
        int inboundWindowSizeOptionValue = connectionOptionMap.get(RemotingOptions.RECEIVE_WINDOW_SIZE, 131072);
        int inboundMessageCountOptionValue = connectionOptionMap.get(RemotingOptions.MAX_INBOUND_MESSAGES, 80);
        long outboundMessageSizeOptionValue = connectionOptionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE, Long.MAX_VALUE);
        long inboundMessageSizeOptionValue = connectionOptionMap.get(RemotingOptions.MAX_INBOUND_MESSAGE_SIZE, Long.MAX_VALUE);
        int outboundWindowSize = optionMap.get(RemotingOptions.TRANSMIT_WINDOW_SIZE, outboundWindowSizeOptionValue);
        int outboundMessageCount = optionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGES, outboundMessageCountOptionValue);
        int inboundWindowSize = optionMap.get(RemotingOptions.RECEIVE_WINDOW_SIZE, inboundWindowSizeOptionValue);
        int inboundMessageCount = optionMap.get(RemotingOptions.MAX_INBOUND_MESSAGES, inboundMessageCountOptionValue);
        long outboundMessageSize = optionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE, outboundMessageSizeOptionValue);
        long inboundMessageSize = optionMap.get(RemotingOptions.MAX_INBOUND_MESSAGE_SIZE, inboundMessageSizeOptionValue);
        IntIndexMap<PendingChannel> pendingChannels = this.pendingChannels;
        try {
            this.handleOutboundChannelOpen();
        }
        catch (IOException e) {
            result.setException(e);
            return IoUtils.nullCancellable();
        }
        boolean ok = false;
        try {
            Cancellable cancellable;
            block17: {
                PendingChannel pendingChannel;
                int id;
                Random random = ProtocolUtils.randomHolder.get();
                while (pendingChannels.containsKey(id = random.nextInt() | Integer.MIN_VALUE) || pendingChannels.putIfAbsent(pendingChannel = new PendingChannel(id, outboundWindowSize, inboundWindowSize, outboundMessageCount, inboundMessageCount, outboundMessageSize, inboundMessageSize, result)) != null) {
                }
                if (RemoteLogger.log.isTraceEnabled()) {
                    RemoteLogger.log.tracef("Outbound service request for channel %08x is configured as follows:\n  outbound window:  option %10d, req %10d\n  inbound window:   option %10d, req %10d\n  outbound msgs:    option %10d, req %10d\n  inbound msgs:     option %10d, req %10d\n  outbound msgsize: option %19d, req %19d\n  inbound msgsize:  option %19d, req %19d", new Object[]{id, outboundWindowSizeOptionValue, outboundWindowSize, inboundWindowSizeOptionValue, inboundWindowSize, outboundMessageCountOptionValue, outboundMessageCount, inboundMessageCountOptionValue, inboundMessageCount, outboundMessageSizeOptionValue, outboundMessageSize, inboundMessageSizeOptionValue, inboundMessageSize});
                }
                if (Bits.anyAreSet((int)this.channelState, (int)-1073741824)) {
                    pendingChannels.remove(pendingChannel);
                    result.setCancelled();
                    Cancellable cancellable2 = IoUtils.nullCancellable();
                    return cancellable2;
                }
                Pooled<ByteBuffer> pooled = this.remoteConnection.allocate();
                try {
                    ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                    buffer.put((byte)16);
                    buffer.putInt(id);
                    ProtocolUtils.writeBytes(buffer, 1, serviceTypeBytes);
                    ProtocolUtils.writeInt(buffer, 128, inboundWindowSize);
                    ProtocolUtils.writeShort(buffer, 129, inboundMessageCount);
                    ProtocolUtils.writeInt(buffer, 130, outboundWindowSize);
                    ProtocolUtils.writeShort(buffer, 131, outboundMessageCount);
                    if (inboundMessageSize != Long.MAX_VALUE) {
                        ProtocolUtils.writeLong(buffer, 132, inboundMessageSize);
                    }
                    if (outboundMessageSize != Long.MAX_VALUE) {
                        ProtocolUtils.writeLong(buffer, 133, outboundMessageSize);
                    }
                    buffer.put((byte)0);
                    buffer.flip();
                    this.remoteConnection.send(pooled);
                    ok = true;
                    RemoteLogger.log.tracef("Completed initiation of service open of type %s on %s", serviceType, this);
                    cancellable = IoUtils.nullCancellable();
                    if (ok) break block17;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        pooled.free();
                    }
                    throw throwable;
                }
                pooled.free();
            }
            return cancellable;
        }
        finally {
            if (!ok) {
                this.handleOutboundChannelClosed();
            }
        }
    }

    @Override
    public Collection<Principal> getPrincipals() {
        return this.principals;
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public SSLSession getSslSession() {
        SslChannel sslChannel = this.remoteConnection.getSslChannel();
        return sslChannel != null ? sslChannel.getSslSession() : null;
    }

    @Override
    public String getRemoteEndpointName() {
        return this.remoteEndpointName;
    }

    @Override
    protected void closeAction() throws IOException {
        this.sendCloseRequest();
        IoUtils.safeShutdownReads((SuspendableReadChannel)this.remoteConnection.getChannel());
        this.remoteConnection.shutdownWrites();
        this.closePendingChannels();
        this.closeAllChannels();
        this.remoteConnection.getRemoteConnectionProvider().removeConnectionHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePendingChannels() {
        ArrayList<PendingChannel> list;
        Iterator<PendingChannel> iterator = this.remoteConnection.getLock();
        synchronized (iterator) {
            list = new ArrayList<PendingChannel>(this.pendingChannels);
        }
        for (PendingChannel pendingChannel : list) {
            pendingChannel.getResult().setCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllChannels() {
        ArrayList<RemoteConnectionChannel> list;
        Iterator<RemoteConnectionChannel> iterator = this.remoteConnection.getLock();
        synchronized (iterator) {
            list = new ArrayList<RemoteConnectionChannel>(this.channels);
        }
        for (RemoteConnectionChannel channel : list) {
            channel.closeAsync();
        }
    }

    ConnectionHandlerContext getConnectionContext() {
        return this.connectionContext;
    }

    RemoteConnectionChannel addChannel(RemoteConnectionChannel channel) {
        return this.channels.putIfAbsent(channel);
    }

    RemoteConnectionChannel getChannel(int id) {
        return this.channels.get(id);
    }

    PendingChannel removePendingChannel(int id) {
        return this.pendingChannels.removeKey(id);
    }

    void putChannel(RemoteConnectionChannel channel) {
        this.channels.put(channel);
    }

    boolean isMessageClose() {
        return Bits.allAreSet((int)this.behavior, (int)1);
    }

    boolean isFaultyMessageSize() {
        return Bits.allAreSet((int)this.behavior, (int)2);
    }

    public String toString() {
        return String.format("Connection handler for %s", this.remoteConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpState(StringBuilder b) {
        Object object = this.remoteConnection.getLock();
        synchronized (object) {
            int state = this.channelState;
            boolean sentCloseReq = Bits.allAreSet((int)state, (int)Integer.MIN_VALUE);
            boolean receivedCloseReq = Bits.allAreSet((int)state, (int)0x40000000);
            int inboundChannels = (state & 0x3FFF8000) >>> Integer.numberOfTrailingZeros(32768);
            int outboundChannels = (state & Short.MAX_VALUE) >>> Integer.numberOfTrailingZeros(1);
            ConnectedMessageChannel channel = this.remoteConnection.getChannel();
            SocketAddress localAddress = channel.getLocalAddress();
            SocketAddress peerAddress = channel.getPeerAddress();
            b.append("    ").append("Connection ").append(localAddress).append(" <-> ").append(peerAddress).append('\n');
            b.append("    ").append("Channel: ").append(channel).append('\n');
            b.append("    ").append("* Flags: ");
            if (Bits.allAreSet((int)this.behavior, (int)1)) {
                b.append("supports-message-close ");
            }
            if (Bits.allAreSet((int)this.behavior, (int)2)) {
                b.append("remote-faulty-message-size ");
            }
            if (receivedCloseReq) {
                b.append("received-close-req ");
            }
            if (sentCloseReq) {
                b.append("set-close-req ");
            }
            b.append('\n');
            b.append("    ").append("* ").append(inboundChannels).append(" (max ").append(this.maxInboundChannels).append(") inbound channels\n");
            b.append("    ").append("* ").append(outboundChannels).append(" (max ").append(this.maxOutboundChannels).append(") outbound channels\n");
            b.append("    ").append("* Channels:\n");
            for (RemoteConnectionChannel connectionChannel : this.channels) {
                connectionChannel.dumpState(b);
            }
        }
    }
}

