/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remotingjmx.protocol.v2.VersionedIoFuture;

class ClientRequestManager {
    private int nextCorrelationId = 1;
    private final Map<Integer, VersionedIoFuture> requests = new HashMap<Integer, VersionedIoFuture>();

    ClientRequestManager() {
    }

    private synchronized int getNextCorrelationId() {
        int next;
        if ((next = this.nextCorrelationId++) < 0) {
            this.nextCorrelationId = 2;
            next = 1;
        }
        return next;
    }

    synchronized int reserveNextCorrelationId(VersionedIoFuture future) {
        Integer next = this.getNextCorrelationId();
        while (this.requests.containsKey(next)) {
            next = this.getNextCorrelationId();
        }
        this.requests.put(next, future);
        return next;
    }

    synchronized <T> VersionedIoFuture<T> getFuture(int correlationId) {
        return this.requests.get(correlationId);
    }

    synchronized void releaseCorrelationId(int correlationId) {
        this.requests.remove(correlationId);
    }

    synchronized void cancelAllRequests(IOException io) {
        for (VersionedIoFuture current : this.requests.values()) {
            current.setException(io);
        }
        this.requests.clear();
    }
}

