/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.resteasy.client.core.ClientInterceptorRepository;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInterceptorRepositoryImpl
implements ClientInterceptorRepository {
    private Map<InterceptorType, LinkedList<?>> interceptorLists = new HashMap();

    public MessageBodyReaderInterceptor[] getReaderInterceptors() {
        return this.getArray(MessageBodyReaderInterceptor.class);
    }

    public MessageBodyWriterInterceptor[] getWriterInterceptors() {
        return this.getArray(MessageBodyWriterInterceptor.class);
    }

    public ClientExecutionInterceptor[] getExecutionInterceptors() {
        return this.getArray(ClientExecutionInterceptor.class);
    }

    private <T> T[] getArray(Class<T> type) {
        LinkedList<Object> interceptors = this.getInterceptors(type);
        return interceptors.toArray((Object[])Array.newInstance(type, interceptors.size()));
    }

    public void setReaderInterceptors(MessageBodyReaderInterceptor[] readerInterceptors) {
        this.setData(InterceptorType.MessageBodyReader, readerInterceptors);
    }

    public void setWriterInterceptors(MessageBodyWriterInterceptor[] writerInterceptors) {
        this.setData(InterceptorType.MessageBodyWriter, writerInterceptors);
    }

    public void setExecutionInterceptors(ClientExecutionInterceptor[] executionInterceptors) {
        this.setData(InterceptorType.ClientExecution, executionInterceptors);
    }

    public void setReaderInterceptors(Collection<MessageBodyReaderInterceptor> readerInterceptorList) {
        this.setData(InterceptorType.MessageBodyReader, readerInterceptorList);
    }

    public void setWriterInterceptors(Collection<MessageBodyWriterInterceptor> writerInterceptorList) {
        this.setData(InterceptorType.MessageBodyWriter, writerInterceptorList);
    }

    public void setExecutionInterceptors(Collection<ClientExecutionInterceptor> executionInterceptorList) {
        this.setData(InterceptorType.ClientExecution, executionInterceptorList);
    }

    @Override
    public LinkedList<MessageBodyReaderInterceptor> getReaderInterceptorList() {
        return this.getInterceptors(InterceptorType.MessageBodyReader);
    }

    @Override
    public LinkedList<MessageBodyWriterInterceptor> getWriterInterceptorList() {
        return this.getInterceptors(InterceptorType.MessageBodyWriter);
    }

    @Override
    public LinkedList<ClientExecutionInterceptor> getExecutionInterceptorList() {
        return this.getInterceptors(InterceptorType.ClientExecution);
    }

    public <T> LinkedList<T> getInterceptors(Class<T> clazz) {
        InterceptorType interceptorType = InterceptorType.getInterceptorTypeFor(clazz);
        if (interceptorType == null) {
            return null;
        }
        return this.getInterceptors(interceptorType);
    }

    protected synchronized LinkedList getInterceptors(InterceptorType interceptorType) {
        LinkedList<Object> interceptors = this.interceptorLists.get((Object)interceptorType);
        if (interceptors == null) {
            interceptors = new LinkedList();
            this.interceptorLists.put(interceptorType, interceptors);
        }
        return interceptors;
    }

    private void setData(InterceptorType type, Object[] arr) {
        this.setData(type, Arrays.asList(arr));
    }

    private void setData(InterceptorType type, Collection newList) {
        LinkedList list = this.getInterceptors(type);
        list.clear();
        list.addAll(newList);
    }

    public void copyClientInterceptorsTo(ClientInterceptorRepositoryImpl copyTo) {
        for (Map.Entry<InterceptorType, LinkedList<?>> entry : this.interceptorLists.entrySet()) {
            LinkedList copyToInterceptors = copyTo.getInterceptors(entry.getKey());
            LinkedList copyFromInterceptors = this.getInterceptors(entry.getKey());
            copyToInterceptors.addAll(copyFromInterceptors);
        }
    }

    public void prefixClientInterceptorsTo(ClientInterceptorRepositoryImpl copyTo) {
        for (Map.Entry<InterceptorType, LinkedList<?>> entry : this.interceptorLists.entrySet()) {
            LinkedList copyToInterceptors = copyTo.getInterceptors(entry.getKey());
            LinkedList copyFromInterceptors = this.getInterceptors(entry.getKey());
            for (Object interceptor : copyFromInterceptors) {
                copyToInterceptors.addFirst(interceptor);
            }
        }
    }

    @Override
    public void registerInterceptor(Object interceptor) {
        boolean registered = false;
        if (interceptor instanceof ClientExecutionInterceptor) {
            this.getExecutionInterceptorList().add((ClientExecutionInterceptor)interceptor);
            registered = true;
        }
        if (interceptor instanceof MessageBodyReaderInterceptor) {
            this.getReaderInterceptorList().add((MessageBodyReaderInterceptor)interceptor);
            registered = true;
        }
        if (interceptor instanceof MessageBodyWriterInterceptor) {
            this.getWriterInterceptorList().add((MessageBodyWriterInterceptor)interceptor);
            registered = true;
        }
        if (!registered) {
            throw new RuntimeException("The object you supplied to registerInterceptor is not of an understood type");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InterceptorType {
        MessageBodyReader(MessageBodyReaderInterceptor.class),
        MessageBodyWriter(MessageBodyWriterInterceptor.class),
        ClientExecution(ClientExecutionInterceptor.class);

        Class<?> clazz;

        public static InterceptorType getInterceptorTypeFor(Class<?> type) {
            for (InterceptorType interceptorType : InterceptorType.values()) {
                if (type != interceptorType.clazz) continue;
                return interceptorType;
            }
            return null;
        }

        private InterceptorType(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

