/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.plugins.providers.FileRange;

public class FileRangeWriter
implements MessageBodyWriter<FileRange> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(FileRange.class);
    }

    public long getSize(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        long fileSize = fileRange.getFile().length();
        String contentRange = fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle((Object)"Content-Range", (Object)contentRange);
        httpHeaders.putSingle((Object)"Content-Length", (Object)length);
        FileInputStream fis = new FileInputStream(fileRange.getFile());
        try {
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            while (length > 0L) {
                int len = 2048L > length ? (int)length : 2048;
                int read = fis.read(buf, 0, len);
                if (read == -1) {
                    break;
                }
                entityStream.write(buf, 0, read);
                length -= (long)len;
            }
        }
        finally {
            fis.close();
        }
    }
}

