/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.MethodExpression;
import org.jboss.resteasy.spi.DefaultOptionsMethodException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.WeightedMediaType;

public class SegmentNode {
    public static final String RESTEASY_CHOSEN_ACCEPT = "RESTEASY_CHOSEN_ACCEPT";
    public static final MediaType[] WILDCARD_ARRAY = new MediaType[]{MediaType.WILDCARD_TYPE};
    public static final List<MediaType> DEFAULT_ACCEPTS = new ArrayList<MediaType>();
    protected String segment;
    protected Map<String, SegmentNode> children = new HashMap<String, SegmentNode>();
    protected List<MethodExpression> targets = new ArrayList<MethodExpression>();

    public SegmentNode(String segment) {
        this.segment = segment;
    }

    public ResourceInvoker match(HttpRequest request, int start) {
        String path = request.getUri().getMatchingPath();
        if (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        ArrayList<MethodExpression> potentials = new ArrayList<MethodExpression>();
        this.potentials(path, start, potentials);
        Collections.sort(potentials);
        boolean expressionMatched = false;
        ArrayList<Match> matches = new ArrayList<Match>();
        for (MethodExpression expression : potentials) {
            if (expressionMatched && expression.isLocator()) continue;
            Pattern pattern = expression.getPattern();
            Matcher matcher = pattern.matcher(path);
            matcher.region(start, path.length());
            if (!matcher.matches()) continue;
            expressionMatched = true;
            ResourceInvoker invoker = expression.getInvoker();
            if (invoker instanceof ResourceLocatorInvoker) {
                ResteasyUriInfo uriInfo = request.getUri();
                int length = matcher.start(expression.getNumGroups() + 1);
                if (length == -1) {
                    uriInfo.pushMatchedPath(path);
                    uriInfo.pushMatchedURI(path);
                } else {
                    String substring = path.substring(0, length);
                    uriInfo.pushMatchedPath(substring);
                    uriInfo.pushMatchedURI(substring);
                }
                expression.populatePathParams(request, matcher, path);
                return invoker;
            }
            matches.add(new Match(expression, matcher));
        }
        if (matches.size() == 0) {
            throw new NotFoundException("Could not find resource for full path: " + request.getUri().getRequestUri());
        }
        Match match = this.match(matches, request.getHttpMethod(), request);
        match.expression.populatePathParams(request, match.matcher, path);
        return match.expression.getInvoker();
    }

    public void potentials(String path, int start, List<MethodExpression> matches) {
        if (start == path.length()) {
            matches.addAll(this.targets);
            return;
        }
        if (start < path.length()) {
            String simpleSegment = null;
            int endOfSegmentIndex = path.indexOf(47, start);
            simpleSegment = endOfSegmentIndex > -1 ? path.substring(start, endOfSegmentIndex) : path.substring(start);
            SegmentNode child = this.children.get(simpleSegment);
            if (child != null) {
                int next = start + simpleSegment.length();
                if (endOfSegmentIndex > -1) {
                    ++next;
                }
                child.potentials(path, next, matches);
            }
        }
        for (MethodExpression exp : this.targets) {
            if (exp.getNumGroups() <= 0 && !(exp.getInvoker() instanceof ResourceLocatorInvoker)) continue;
            matches.add(exp);
        }
    }

    public static MediaType createSortFactor(MediaType client, MediaType server) {
        String val;
        String name;
        String qs;
        String subtype;
        String type;
        int d = 0;
        if (client.isWildcardType() != server.isWildcardType()) {
            type = client.isWildcardType() ? server.getType() : client.getType();
            ++d;
        } else {
            type = client.getType();
        }
        if (client.isWildcardSubtype() != server.isWildcardSubtype()) {
            subtype = client.isWildcardSubtype() ? server.getSubtype() : client.getSubtype();
            ++d;
        } else {
            subtype = client.getSubtype();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String q = (String)client.getParameters().get("q");
        if (q != null) {
            params.put("q", q);
        }
        if ((qs = (String)server.getParameters().get("qs")) != null) {
            params.put("qs", qs);
        }
        params.put("d", Integer.toString(d));
        int dm = 0;
        for (Map.Entry entry : client.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)server.getParameters().get(name);
            if (val == null) {
                ++dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++dm;
        }
        for (Map.Entry entry : server.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)client.getParameters().get(name);
            if (val == null) {
                ++dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++dm;
        }
        params.put("dm", Integer.toString(dm));
        return new MediaType(type, subtype, params);
    }

    public Match match(List<Match> matches, String httpMethod, HttpRequest request) {
        MediaType contentType = request.getHttpHeaders().getMediaType();
        List oldaccepts = request.getHttpHeaders().getAcceptableMediaTypes();
        ArrayList<WeightedMediaType> accepts = new ArrayList<WeightedMediaType>();
        for (MediaType accept : oldaccepts) {
            accepts.add(WeightedMediaType.parse(accept));
        }
        ArrayList<Match> list = new ArrayList<Match>();
        boolean methodMatch = false;
        boolean consumeMatch = false;
        for (Match match : matches) {
            ResourceMethodInvoker invoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (!invoker.getHttpMethods().contains(httpMethod)) continue;
            methodMatch = true;
            if (!invoker.doesConsume(contentType)) continue;
            consumeMatch = true;
            if (!invoker.doesProduce(accepts)) continue;
            list.add(match);
        }
        if (list.size() == 0) {
            if (!methodMatch) {
                Response res;
                HashSet<String> allowed = new HashSet<String>();
                for (Match match : matches) {
                    allowed.addAll(((ResourceMethodInvoker)match.expression.getInvoker()).getHttpMethods());
                }
                if (httpMethod.equalsIgnoreCase("HEAD") && allowed.contains("GET")) {
                    return this.match(matches, "GET", request);
                }
                if (allowed.contains("GET")) {
                    allowed.add("HEAD");
                }
                allowed.add("OPTIONS");
                String allowHeaderValue = "";
                boolean first = true;
                for (String allow : allowed) {
                    if (first) {
                        first = false;
                    } else {
                        allowHeaderValue = allowHeaderValue + ", ";
                    }
                    allowHeaderValue = allowHeaderValue + allow;
                }
                if (httpMethod.equals("OPTIONS")) {
                    res = Response.ok((Object)allowHeaderValue, (MediaType)MediaType.TEXT_PLAIN_TYPE).header("Allow", (Object)allowHeaderValue).build();
                    throw new DefaultOptionsMethodException("No resource method found for options, return OK with Allow header", res);
                }
                res = Response.status((int)405).header("Allow", (Object)allowHeaderValue).build();
                throw new NotAllowedException("No resource method found for " + httpMethod + ", return 405 with Allow header", res);
            }
            if (!consumeMatch) {
                throw new NotSupportedException("Cannot consume content type");
            }
            throw new NotAcceptableException("No match for accept header");
        }
        ArrayList<SortEntry> sortList = new ArrayList<SortEntry>();
        for (Match match : list) {
            MediaType[] produces;
            MediaType[] consumes;
            ResourceMethodInvoker invoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (contentType == null) {
                contentType = MediaType.WILDCARD_TYPE;
            }
            if ((consumes = invoker.getConsumes()).length == 0) {
                consumes = WILDCARD_ARRAY;
            }
            if ((produces = invoker.getProduces()).length == 0) {
                produces = WILDCARD_ARRAY;
            }
            ArrayList<MediaType> consumeCombo = new ArrayList<MediaType>();
            for (MediaType consume : consumes) {
                consumeCombo.add(SegmentNode.createSortFactor(contentType, consume));
            }
            for (MediaType produce : produces) {
                List<MediaType> acceptableMediaTypes = request.getHttpHeaders().getAcceptableMediaTypes();
                if (acceptableMediaTypes.size() == 0) {
                    acceptableMediaTypes = DEFAULT_ACCEPTS;
                }
                for (MediaType accept : acceptableMediaTypes) {
                    if (!accept.isCompatible(produce)) continue;
                    MediaType sortFactor = SegmentNode.createSortFactor(accept, produce);
                    HashMap params = new HashMap();
                    for (Map.Entry entry : produce.getParameters().entrySet()) {
                        String name = (String)entry.getKey();
                        if ("q".equals(name) || "qs".equals(name)) continue;
                        params.put(name, entry.getValue());
                    }
                    MediaType chosen = new MediaType(sortFactor.getType(), sortFactor.getSubtype(), params);
                    for (MediaType consume : consumeCombo) {
                        sortList.add(new SortEntry(match, consume, sortFactor, chosen));
                    }
                }
            }
        }
        Collections.sort(sortList);
        SortEntry sortEntry = (SortEntry)sortList.get(0);
        request.setAttribute(RESTEASY_CHOSEN_ACCEPT, sortEntry.accept);
        return sortEntry.match;
    }

    protected void addExpression(MethodExpression expression) {
        this.targets.add(expression);
        Collections.sort(this.targets);
    }

    static {
        DEFAULT_ACCEPTS.add(MediaType.WILDCARD_TYPE);
    }

    protected class SortEntry
    implements Comparable<SortEntry> {
        Match match;
        MediaType accept;
        MediaType consumes;
        float qConsumes = 1.0f;
        float qsConsumes = 1.0f;
        int dConsumes = 0;
        int dmConsumes = 0;
        MediaType produces;
        float qProduces = 1.0f;
        float qsProduces = 1.0f;
        int dProduces = 0;
        int dmProduces = 0;

        public SortEntry(Match match, MediaType consumes, MediaType produces, MediaType accept) {
            String dm;
            String d;
            String qs;
            this.accept = accept;
            this.match = match;
            this.consumes = consumes;
            String q = (String)consumes.getParameters().get("q");
            if (q != null) {
                this.qConsumes = Float.parseFloat(q);
            }
            if ((qs = (String)consumes.getParameters().get("qs")) != null) {
                this.qsConsumes = Float.parseFloat(qs);
            }
            if ((d = (String)consumes.getParameters().get("d")) != null) {
                this.dConsumes = Integer.parseInt(d);
            }
            if ((dm = (String)consumes.getParameters().get("dm")) != null) {
                this.dmConsumes = Integer.parseInt(dm);
            }
            this.produces = produces;
            q = (String)produces.getParameters().get("q");
            if (q != null) {
                this.qProduces = Float.parseFloat(q);
            }
            if ((qs = (String)produces.getParameters().get("qs")) != null) {
                this.qsProduces = Float.parseFloat(qs);
            }
            if ((d = (String)produces.getParameters().get("d")) != null) {
                this.dProduces = Integer.parseInt(d);
            }
            if ((dm = (String)produces.getParameters().get("dm")) != null) {
                this.dmProduces = Integer.parseInt(dm);
            }
        }

        @Override
        public int compareTo(SortEntry o) {
            if (this.consumes.isWildcardType() && !o.consumes.isWildcardType()) {
                return 1;
            }
            if (!this.consumes.isWildcardType() && o.consumes.isWildcardType()) {
                return -1;
            }
            if (this.consumes.isWildcardSubtype() && !o.consumes.isWildcardSubtype()) {
                return 1;
            }
            if (!this.consumes.isWildcardSubtype() && o.consumes.isWildcardSubtype()) {
                return -1;
            }
            if (this.qConsumes > o.qConsumes) {
                return -1;
            }
            if (this.qConsumes < o.qConsumes) {
                return 1;
            }
            if (this.qsConsumes > o.qsConsumes) {
                return -1;
            }
            if (this.qsConsumes < o.qsConsumes) {
                return 1;
            }
            if (this.dConsumes < o.dConsumes) {
                return -1;
            }
            if (this.dConsumes > o.dConsumes) {
                return 1;
            }
            if (this.dmConsumes < o.dmConsumes) {
                return -1;
            }
            if (this.dmConsumes > o.dmConsumes) {
                return 1;
            }
            if (this.produces.isWildcardType() && !o.produces.isWildcardType()) {
                return 1;
            }
            if (!this.produces.isWildcardType() && o.produces.isWildcardType()) {
                return -1;
            }
            if (this.produces.isWildcardSubtype() && !o.produces.isWildcardSubtype()) {
                return 1;
            }
            if (!this.produces.isWildcardSubtype() && o.produces.isWildcardSubtype()) {
                return -1;
            }
            if (this.qProduces > o.qProduces) {
                return -1;
            }
            if (this.qProduces < o.qProduces) {
                return 1;
            }
            if (this.qsProduces > o.qsProduces) {
                return -1;
            }
            if (this.qsProduces < o.qsProduces) {
                return 1;
            }
            if (this.dProduces < o.dProduces) {
                return -1;
            }
            if (this.dProduces > o.dProduces) {
                return 1;
            }
            if (this.dmProduces < o.dmProduces) {
                return -1;
            }
            if (this.dmProduces > o.dmProduces) {
                return 1;
            }
            return this.match.expression.compareTo(o.match.expression);
        }
    }

    protected static class Match {
        MethodExpression expression;
        Matcher matcher;

        public Match(MethodExpression expression, Matcher matcher) {
            this.expression = expression;
            this.matcher = matcher;
        }
    }
}

