/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.SseElementType;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final ResteasyAsynchronousContext asyncContext;
    private final HttpResponse response;
    private final HttpRequest request;
    private volatile boolean closed;
    private final Map<Class<?>, Object> contextDataMap;
    private boolean responseFlushed = false;
    private final Object lock = new Object();

    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer) {
        this.writer = writer;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
        this.request = ResteasyProviderFactory.getContextData(HttpRequest.class);
        this.asyncContext = this.request.getAsyncContext();
        if (!this.asyncContext.isSuspended()) {
            try {
                this.asyncContext.suspend();
            }
            catch (IllegalStateException ex) {
                LogMessages.LOGGER.failedToSetRequestAsync();
            }
        }
        this.response = ResteasyProviderFactory.getContextData(HttpResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            ResteasyAsynchronousResponse asyncResponse;
            this.closed = true;
            if (this.asyncContext.isSuspended() && (asyncResponse = this.asyncContext.getAsyncResponse()) != null) {
                asyncResponse.complete();
            }
        }
    }

    protected void flushResponseToClient() {
        try {
            this.internalFlushResponseToClient(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlushResponseToClient(boolean throwIOException) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responseFlushed) {
                BuiltResponse jaxrsResponse = null;
                if (this.closed) {
                    jaxrsResponse = (BuiltResponse)Response.noContent().build();
                } else {
                    ResourceMethodInvoker method = (ResourceMethodInvoker)this.request.getAttribute(ResourceMethodInvoker.class.getName());
                    Produces produces = method.getMethod().getAnnotation(Produces.class);
                    if (produces != null && this.contains(produces.value(), "text/event-stream")) {
                        SseElementType sseElementType = method.getMethod().getAnnotation(SseElementType.class);
                        if (sseElementType != null) {
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", sseElementType.value());
                            MediaType mediaType = new MediaType(MediaType.SERVER_SENT_EVENTS_TYPE.getType(), MediaType.SERVER_SENT_EVENTS_TYPE.getSubtype(), parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            jaxrsResponse = (BuiltResponse)Response.ok().type("text/event-stream").build();
                        }
                    } else {
                        Stream stream = method.getMethod().getAnnotation(Stream.class);
                        if (stream != null) {
                            jaxrsResponse = (BuiltResponse)Response.ok((Object)"").build();
                            MediaType elementType = ServerResponseWriter.getResponseMediaType(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), method);
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", elementType.toString());
                            String[] streamType = this.getStreamType(method);
                            MediaType mediaType = new MediaType(streamType[0], streamType[1], parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            throw new RuntimeException(Messages.MESSAGES.expectedStreamOrSseMediaType());
                        }
                    }
                }
                try {
                    ServerResponseWriter.writeNomapResponse(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), t -> {}, true);
                    this.response.getOutputStream().write(SseConstants.EOL);
                    this.response.getOutputStream().write(SseConstants.EOL);
                    this.response.flushBuffer();
                    this.responseFlushed = true;
                }
                catch (IOException e) {
                    this.close();
                    if (throwIOException) {
                        throw e;
                    }
                    throw new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), (Throwable)e);
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<?> send(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(Messages.MESSAGES.sseEventSinkIsClosed());
            }
            try {
                this.internalFlushResponseToClient(true);
                this.writeEvent(event);
            }
            catch (Exception ex) {
                CompletableFuture completableFuture = new CompletableFuture();
                completableFuture.completeExceptionally(ex);
                return completableFuture;
            }
            return CompletableFuture.completedFuture(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEvent(OutboundSseEvent event) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            try {
                if (event != null) {
                    Object o;
                    boolean mediaTypeSet;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    MediaType mediaType = event.getMediaType();
                    boolean bl = mediaTypeSet = event instanceof OutboundSseEventImpl ? ((OutboundSseEventImpl)event).isMediaTypeSet() : true;
                    if (!(mediaType != null && mediaTypeSet || (o = this.response.getOutputHeaders().getFirst((Object)"Content-Type")) == null)) {
                        if (o instanceof MediaType) {
                            MediaType mt = (MediaType)o;
                            String s = (String)mt.getParameters().get("element-type");
                            if (s != null) {
                                mediaType = MediaType.valueOf((String)s);
                            }
                        } else if (o instanceof String) {
                            MediaType mt = MediaType.valueOf((String)((String)o));
                            String s = (String)mt.getParameters().get("element-type");
                            if (s != null) {
                                mediaType = MediaType.valueOf((String)s);
                            }
                        } else {
                            throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
                        }
                    }
                    if (mediaType == null) {
                        mediaType = MediaType.TEXT_PLAIN_TYPE;
                    }
                    if (event instanceof OutboundSseEventImpl) {
                        ((OutboundSseEventImpl)event).setMediaType(mediaType);
                    }
                    this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], mediaType, null, (OutputStream)bout);
                    this.response.getOutputStream().write(bout.toByteArray());
                    this.response.flushBuffer();
                }
            }
            catch (IOException e) {
                this.close();
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                throw e;
            }
            catch (Exception e) {
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                throw new ProcessingException((Throwable)e);
            }
            finally {
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }

    private String[] getStreamType(ResourceMethodInvoker method) {
        Stream.MODE mode;
        Stream stream = method.getMethod().getAnnotation(Stream.class);
        Stream.MODE mODE = mode = stream != null ? stream.value() : null;
        if (mode == null) {
            return new String[]{"text", "event-stream"};
        }
        if (Stream.MODE.GENERAL.equals((Object)mode)) {
            return new String[]{"application", "x-stream-general"};
        }
        if (Stream.MODE.RAW.equals((Object)mode)) {
            return new String[]{"application", "x-stream-raw"};
        }
        throw new RuntimeException(Messages.MESSAGES.expectedStreamModeGeneralOrRaw(mode));
    }

    private boolean contains(String[] ss, String t) {
        for (String s : ss) {
            if (!s.startsWith(t)) continue;
            return true;
        }
        return false;
    }
}

