/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.annotations.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Set;

/**
 * New index/repository -- per classpath entry.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 */
public interface AnnotationIndex extends AnnotationRepository
{
   /**
    * Get all classes who have annotated type annotated with annotation param.
    *
    * @param <A>        the annotation type
    * @param url        the classpath entry, if null all classes in classpath are checked
    * @param annotation the annotation we're querying for
    * @param type       annotation element type, if null all types are matched
    * @return set of matching classes
    */
   <A extends Annotation> Set<Element<A, AnnotatedElement>> getAnnotatedClasses(URL url, Class<A> annotation, ElementType type);

   /**
    * Index of classes that implement an interface that are annotated directly with an annotation:
    * <p/>
    * i.e.
    * <p/>
    * <pre>&#64;Path("/foo")
    * public interface MyIntf {}
    * <p/>
    * public class MyResource implements MyIntf {}
    * </pre>
    * <p/>
    * In this case MyResource is related to @Path through MyIntf
    *
    * @param annotation the annotation to check for
    * @return classes implementing the interfaces with given annotation
    */
   Set<String> classesImplementingInterfacesAnnotatedWith(String annotation);
}
