/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.spi;

/**
 * Simple scanner interface.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public interface Scanner
{
   /** The meta-inf prefix */
   public static final String META_INF = "META-INF/";

   /** The pre-existing files suffix */
   public static final String SUFFIX = ".mcs";

   /** Ignore flags */
   public static final String IGNORE_PRE_INDEXED = "jboss.scanning.ignoreIndexedHandles";
   public static final String IGNORE_RUNTIME_SCAN = "jboss.scanning.ignoreRuntimeScanning";

   /**
    * Scan handle method.
    *
    * @throws Exception for any error
    */
   void scan() throws Exception;
}
