/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status;

import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class ApplicationBundles
implements Serializable {
    private static final long serialVersionUID = 1207758648760266247L;
    private final Map<Locale, Map<String, ResourceBundle>> bundles = new ConcurrentHashMap<Locale, Map<String, ResourceBundle>>();
    @Inject
    Locale appLocale;

    public void clear(Locale locale) {
        this.containsLocaleMap(locale);
        this.bundles.get(locale).clear();
    }

    public boolean containsKey(Locale locale, Object key) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).containsKey(key);
    }

    public boolean containsValue(Locale locale, Object value) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).containsValue(value);
    }

    public Set<Map.Entry<String, ResourceBundle>> entrySet(Locale locale) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).entrySet();
    }

    public ResourceBundle get(Object key) {
        return this.get(this.appLocale, key);
    }

    public ResourceBundle get(Locale locale, Object key) {
        this.containsLocaleMap(locale);
        if (!this.bundles.get(locale).containsKey(key)) {
            ResourceBundle bundle = ResourceBundle.getBundle(key.toString(), locale);
            this.put(locale, key.toString(), bundle);
        }
        return this.bundles.get(locale).get(key);
    }

    public boolean isEmpty(Locale locale) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).isEmpty();
    }

    public Set<String> keySet(Locale locale) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).keySet();
    }

    public ResourceBundle put(Locale locale, String key, ResourceBundle value) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).put(key, value);
    }

    public void putAll(Locale locale, Map<? extends String, ? extends ResourceBundle> m) {
        this.containsLocaleMap(locale);
        this.bundles.get(locale).putAll(m);
    }

    public ResourceBundle remove(Locale locale, Object key) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).remove(key);
    }

    public int size(Locale locale) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).size();
    }

    public Collection<ResourceBundle> values(Locale locale) {
        this.containsLocaleMap(locale);
        return this.bundles.get(locale).values();
    }

    private void containsLocaleMap(Locale locale) {
        if (!this.bundles.containsKey(locale)) {
            this.bundles.put(locale, new ConcurrentHashMap());
        }
    }
}

