/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.Serializable;
import org.jboss.seam.async.QuartzDispatcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class QuartzTriggerHandle
implements Serializable {
    private String triggerName;
    private transient Scheduler scheduler;

    public QuartzTriggerHandle(String triggerName) {
        this.triggerName = triggerName;
        this.scheduler = QuartzDispatcher.instance().getScheduler();
    }

    public void cancel() throws SchedulerException {
        this.getScheduler().unscheduleJob(this.triggerName, null);
    }

    public void pause() throws SchedulerException {
        this.getScheduler().pauseTrigger(this.triggerName, null);
    }

    public void resume() throws SchedulerException {
        this.getScheduler().resumeTrigger(this.triggerName, null);
    }

    private Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = QuartzDispatcher.instance().getScheduler();
        }
        return this.scheduler;
    }
}

