/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.openid;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.Redirect;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.openid.OpenIdPrincipal;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

@Name(value="openid")
@Install(precedence=0, classDependencies={"org.openid4java.consumer.ConsumerManager"})
@Scope(value=ScopeType.SESSION)
public class OpenId
implements Serializable {
    String id;
    String validatedId;
    ConsumerManager manager;
    DiscoveryInformation discovered;

    @Create
    public void init() throws ConsumerException {
        this.manager = new ConsumerManager();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String returnToUrl() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String returnToUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + context.getApplication().getViewHandler().getActionURL(context, "/openid.xhtml");
        return returnToUrl;
    }

    public void login() throws IOException {
        this.validatedId = null;
        String returnToUrl = this.returnToUrl();
        System.out.println("return to " + returnToUrl);
        String url = this.authRequest(this.id, returnToUrl);
        System.out.println("auth to --> " + url);
        Redirect redirect = Redirect.instance();
        redirect.captureCurrentView();
        FacesManager.instance().redirectToExternalURL(url);
    }

    protected String authRequest(String userSuppliedString, String returnToUrl) throws IOException {
        try {
            List discoveries = this.manager.discover(userSuppliedString);
            this.discovered = this.manager.associate(discoveries);
            AuthRequest authReq = this.manager.authenticate(this.discovered, returnToUrl);
            FetchRequest fetch = FetchRequest.createFetchRequest();
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
            authReq.addExtension((MessageExtension)fetch);
            return authReq.getDestinationUrl(true);
        }
        catch (OpenIDException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void verify() {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        this.validatedId = this.verifyResponse(request);
    }

    public boolean loginImmediately() {
        System.out.println("* LOGIN IMMEDIATELY! " + this.validatedId);
        if (this.validatedId != null) {
            Identity.instance().acceptExternallyAuthenticatedPrincipal(new OpenIdPrincipal(this.validatedId));
            return true;
        }
        return false;
    }

    public boolean isValid() {
        System.out.println("is valid?" + this.validatedId);
        return this.validatedId != null;
    }

    public String validatedId() {
        return this.validatedId;
    }

    public String verifyResponse(HttpServletRequest httpReq) {
        try {
            VerificationResult verification;
            Identifier verified;
            ParameterList response = new ParameterList(httpReq.getParameterMap());
            System.out.println("DISCOVERED IS " + this.discovered);
            StringBuffer receivingURL = httpReq.getRequestURL();
            String queryString = httpReq.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(httpReq.getQueryString());
            }
            if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, this.discovered)).getVerifiedId()) != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0-draft7")) {
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0-draft7");
                    List emails = fetchResp.getAttributeValues("email");
                    String email = (String)emails.get(0);
                    System.out.println("XXX email is " + email);
                }
                return verified.getIdentifier();
            }
        }
        catch (OpenIDException openIDException) {
            // empty catch block
        }
        return null;
    }
}

