/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.TransactionPropagationType;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.bpm.BusinessProcessInterceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.core.ConversationInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.RollbackInterceptor;
import org.jboss.seam.util.Work;

@Interceptor(stateless=false, around={RollbackInterceptor.class, BusinessProcessInterceptor.class, ConversationInterceptor.class, BijectionInterceptor.class})
public class TransactionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -4364203056333738988L;
    private Map<AnnotatedElement, TransactionMetadata> transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();

    private TransactionMetadata lookupTransactionMetadata(AnnotatedElement element) {
        TransactionMetadata metadata = this.transactionMetadata.get(element);
        if (metadata == null) {
            metadata = this.loadMetadata(element);
        }
        return metadata;
    }

    private synchronized TransactionMetadata loadMetadata(AnnotatedElement element) {
        if (!this.transactionMetadata.containsKey(element)) {
            TransactionMetadata metadata = new TransactionMetadata(element);
            this.transactionMetadata.put(element, metadata);
            return metadata;
        }
        return this.transactionMetadata.get(element);
    }

    @AroundInvoke
    public Object aroundInvoke(final InvocationContext invocation) throws Exception {
        return new Work(){

            protected Object work() throws Exception {
                return invocation.proceed();
            }

            protected boolean isNewTransactionRequired(boolean transactionActive) {
                return this.isNewTransactionRequired(invocation.getMethod(), TransactionInterceptor.this.getComponent().getBeanClass(), transactionActive);
            }

            private boolean isNewTransactionRequired(Method method, Class beanClass, boolean transactionActive) {
                TransactionMetadata metadata = TransactionInterceptor.this.lookupTransactionMetadata(method);
                if (metadata.isNewTransactionRequired(transactionActive)) {
                    return true;
                }
                metadata = TransactionInterceptor.this.lookupTransactionMetadata(beanClass);
                return metadata.isNewTransactionRequired(transactionActive);
            }
        }.workInTransaction();
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().getType() == ComponentType.JAVA_BEAN && this.getComponent().beanClassHasAnnotation(Transactional.class);
    }

    private class TransactionMetadata {
        private boolean annotationPresent;
        TransactionPropagationType propType;

        public TransactionMetadata(AnnotatedElement element) {
            this.annotationPresent = element.isAnnotationPresent(Transactional.class);
            if (this.annotationPresent) {
                this.propType = element.getAnnotation(Transactional.class).value();
            }
        }

        public boolean isAnnotationPresent() {
            return this.annotationPresent;
        }

        public boolean isNewTransactionRequired(boolean transactionActive) {
            return this.propType != null && this.propType.isNewTransactionRequired(transactionActive);
        }
    }
}

