/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.SecurityActions;

public class IdentityFactory {
    public static final String IDENTITY_CLASS = "org.jboss.security.identity.plugins.SimpleIdentity";
    public static final String PRINCIPAL_CLASS = "org.jboss.security.SimplePrincipal";
    public static final String GROUP_CLASS = "org.jboss.security.SimpleGroup";

    public static Principal createPrincipal(String name) throws Exception {
        return (Principal)IdentityFactory.loadClass(PRINCIPAL_CLASS, name);
    }

    public static Group createGroup(String name) throws Exception {
        return (Group)IdentityFactory.loadClass(GROUP_CLASS, name);
    }

    public static Identity createIdentity(String name) throws Exception {
        return (Identity)IdentityFactory.loadClass(IDENTITY_CLASS, name);
    }

    public static Identity createIdentity(String identityClass, String name) throws Exception {
        return (Identity)IdentityFactory.loadClass(identityClass, name);
    }

    private static Object loadClass(String className, String ctorArg) throws Exception {
        Class<?> clazz = SecurityActions.getClass(className);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return ctr.newInstance(ctorArg);
    }
}

