/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.security.mapping.config;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.jboss.logging.Logger;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.RoleMappingInfo;
import org.jboss.xb.binding.GenericValueContainer;

//$Id: RoleMappingConfigContainer.java 45942 2006-06-28 02:14:46Z asaldhana $

/**
 * A container for creating RoleMappingConfig during jbxb parse.
 *  
 * @author Anil.Saldhana@jboss.org 
 * @version $Revision: 45942 $
 */
public class RoleMappingConfigContainer
   implements GenericValueContainer
{
   private static Logger log = Logger.getLogger(RoleMappingConfigContainer.class); 
 
   private List<MappingModuleEntry> moduleEntries = new ArrayList<MappingModuleEntry>();
   
   /**
    * @see GenericValueContainer#addChild(javax.xml.namespace.QName, java.lang.Object)
    */
   public void addChild(QName name, Object value)
   {
      if(log.isTraceEnabled())
         log.trace("addChild:Qname="+name+":value="+value);
      if(value instanceof MappingModuleEntry)
      {
         MappingModuleEntry mme = (MappingModuleEntry) value;
         this.moduleEntries.add(mme);
      }   
   }  

   /**
    * @see GenericValueContainer#instantiate()
    */
   public Object instantiate()
   { 
      /**
       * Currently we do not have the name of the application policy
       * This will be rectified in the ApplicationPolicyContainer
       */
      MappingInfo ri = new RoleMappingInfo("dummy");
      ri.add(moduleEntries);
      return ri;
   }

   /**
    * @see GenericValueContainer#getTargetClass()
    */
   public Class<?> getTargetClass()
   {
      return RoleMappingInfo.class;
   } 
}
