/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.jetty_7.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkWrapWebAppContext
extends WebAppContext
implements Assignable {
    private static final Logger log = Logger.getLogger(ShrinkWrapWebAppContext.class.getName());
    private static final String SYSPROP_KEY_TMP_DIR = "java.io.tmpdir";
    private static final String EXPORT_FILE_PREFIX = "export";
    private static final File TMP_DIR = new File(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty(ShrinkWrapWebAppContext.SYSPROP_KEY_TMP_DIR);
        }
    }));
    private static final char ROOT = '/';
    private final Archive<?> archive;

    public ShrinkWrapWebAppContext(Archive<?> archive) throws IllegalArgumentException {
        URL url;
        File exported;
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        String name = archive.getName();
        int extensionOffset = name.lastIndexOf(46);
        String baseName = extensionOffset >= 0 ? name.substring(0, extensionOffset) : name;
        try {
            exported = File.createTempFile(EXPORT_FILE_PREFIX, name, TMP_DIR);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary File in " + TMP_DIR + " to write exported archive", e);
        }
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exported, true);
        exported.deleteOnExit();
        try {
            url = exported.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain URL of File " + exported.getAbsolutePath(), e);
        }
        log.info("Webapp archive location: " + url);
        this.setWar(url.toExternalForm());
        this.setContextPath('/' + baseName);
        this.archive = archive;
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        return (TYPE)this.archive.as(clazz);
    }

    static {
        if (!TMP_DIR.exists() || !TMP_DIR.isDirectory()) {
            throw new IllegalStateException("Could not obtain temp directory \"" + TMP_DIR.getAbsolutePath() + "\"");
        }
    }
}

