/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import javax.security.auth.login.LoginContext;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.util.AppCallbackHandler;

public class JBossTestServices
extends AbstractTestDelegate {
    public static final String DEPLOYER_NAME = "jboss.system:service=MainDeployer";
    public static final String DEFAULT_USERNAME = "jduke";
    public static final String DEFAULT_PASSWORD = "theduke";
    public static final String DEFAULT_LOGIN_CONFIG = "other";
    public static final int DEFAULT_THREADCOUNT = 10;
    public static final int DEFAULT_ITERATIONCOUNT = 1000;
    public static final int DEFAULT_BEANCOUNT = 100;
    protected MBeanServerConnection server;
    protected InitialContext initialContext;
    protected Hashtable jndiEnv;
    protected LoginContext lc;

    private static Class getClass(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    public JBossTestServices(String className) {
        super(JBossTestServices.getClass(className));
    }

    public JBossTestServices(Class clazz) {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.log = this.getLog();
        this.log.debug((Object)"JBossTestServices.setUp()");
        this.init();
        this.log.info((Object)("jbosstest.beancount: " + System.getProperty("jbosstest.beancount")));
        this.log.info((Object)("jbosstest.iterationcount: " + System.getProperty("jbosstest.iterationcount")));
        this.log.info((Object)("jbosstest.threadcount: " + System.getProperty("jbosstest.threadcount")));
        this.log.info((Object)("jbosstest.nodeploy: " + System.getProperty("jbosstest.nodeploy")));
        this.log.info((Object)("jbosstest.jndiurl: " + this.getJndiURL()));
        this.log.info((Object)("jbosstest.jndifactory: " + this.getJndiInitFactory()));
    }

    public void tearDown() throws Exception {
        this.log.debug((Object)"JBossTestServices.tearDown()");
    }

    public InitialContext getInitialContext() throws Exception {
        return this.initialContext;
    }

    public MBeanServerConnection getServer() throws Exception {
        if (this.server == null) {
            String adaptorName = System.getProperty("jbosstest.server.name", "jmx/invoker/RMIAdaptor");
            this.server = (MBeanServerConnection)this.initialContext.lookup(adaptorName);
        }
        return this.server;
    }

    ObjectName getDeployerName() throws MalformedObjectNameException {
        return new ObjectName(DEPLOYER_NAME);
    }

    protected URL getDeployURL(String filename) throws MalformedURLException {
        try {
            return new URL(filename);
        }
        catch (MalformedURLException e) {
            this.log.debug((Object)(filename + " is not a valid URL, " + e.getMessage()));
            String deployDir = System.getProperty("jbosstest.deploy.dir");
            if (deployDir == null) {
                deployDir = "output/lib";
            }
            String url = deployDir + "/" + filename;
            this.log.debug((Object)("Testing file: " + url));
            File file = new File(url);
            if (file.exists()) {
                this.log.debug((Object)(file.getAbsolutePath() + " is a valid file"));
                return file.toURL();
            }
            this.log.debug((Object)("File does not exist, creating url: " + url));
            return new URL(url);
        }
    }

    protected Object invoke(ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        return this.invoke(this.getServer(), name, method, args, sig);
    }

    protected Object invoke(MBeanServerConnection server, ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        try {
            this.getLog().debug((Object)("Invoking " + name.getCanonicalName() + " method=" + method));
            if (args != null) {
                this.getLog().debug((Object)("args=" + Arrays.asList(args)));
            }
            return server.invoke(name, method, args, sig);
        }
        catch (MBeanException e) {
            this.log.error((Object)"MbeanException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (ReflectionException e) {
            this.log.error((Object)"ReflectionException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeOperationsException e) {
            this.log.error((Object)"RuntimeOperationsException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeMBeanException e) {
            this.log.error((Object)"RuntimeMbeanException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeErrorException e) {
            this.log.error((Object)"RuntimeErrorException", (Throwable)e.getTargetError());
            throw e.getTargetError();
        }
    }

    public void deploy(String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            this.log.debug((Object)("Skipping deployment of: " + name));
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Deploying " + name + ", url=" + deployURL));
        this.invoke(this.getDeployerName(), "deploy", new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void redeploy(String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            this.log.debug((Object)("Skipping redeployment of: " + name));
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Deploying " + name + ", url=" + deployURL));
        this.invoke(this.getDeployerName(), "redeploy", new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void login() throws Exception {
        try {
            this.flushAuthCache(DEFAULT_LOGIN_CONFIG);
        }
        catch (Exception e) {
            this.getLog().debug((Object)("Failed to flushAuthCache; " + e));
        }
        String username = this.getUsername();
        String pass = this.getPassword();
        String config = this.getLoginConfig();
        char[] password = null;
        if (pass != null) {
            password = pass.toCharArray();
        }
        AppCallbackHandler handler = new AppCallbackHandler(username, password);
        this.getLog().debug((Object)("Creating LoginContext(" + config + ")"));
        this.lc = new LoginContext(config, handler);
        this.lc.login();
        this.getLog().debug((Object)("Created LoginContext, subject=" + this.lc.getSubject()));
    }

    public void logout() {
        try {
            this.getLog().debug((Object)("logout, LoginContext: " + this.lc));
            if (this.lc != null) {
                this.lc.logout();
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)"logout error: ", (Throwable)e);
        }
    }

    public void undeploy(String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Undeploying " + name + ", url=" + deployURL));
        Object[] args = new Object[]{deployURL};
        String[] sig = new String[]{"java.net.URL"};
        this.invoke(this.getDeployerName(), "undeploy", args, sig);
    }

    void flushAuthCache(String domain) throws Exception {
        ObjectName jaasMgr = new ObjectName("jboss.security:service=JaasSecurityManager");
        Object[] params = new Object[]{domain};
        String[] signature = new String[]{"java.lang.String"};
        this.invoke(jaasMgr, "flushAuthenticationCache", params, signature);
    }

    void restartDBPool() throws Exception {
        ObjectName dbPool = new ObjectName("jboss.jca:service=ManagedConnectionPool,name=DefaultDS");
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        this.invoke(dbPool, "stop", params, signature);
        this.invoke(dbPool, "start", params, signature);
    }

    boolean isSecure() {
        return Boolean.getBoolean("jbosstest.secure");
    }

    String getUsername() {
        return System.getProperty("jbosstest.username", DEFAULT_USERNAME);
    }

    String getPassword() {
        return System.getProperty("jbosstest.password", DEFAULT_PASSWORD);
    }

    String getLoginConfig() {
        return System.getProperty("jbosstest.loginconfig", DEFAULT_LOGIN_CONFIG);
    }

    String getJndiURL() {
        String url = (String)this.jndiEnv.get("java.naming.provider.url");
        return url;
    }

    String getJndiInitFactory() {
        String factory = (String)this.jndiEnv.get("java.naming.factory.initial");
        return factory;
    }

    int getThreadCount() {
        int result = Integer.getInteger("jbosstest.threadcount", 10);
        this.log.debug((Object)("jbosstest.threadcount=" + result));
        return result;
    }

    int getIterationCount() {
        int result = Integer.getInteger("jbosstest.iterationcount", 1000);
        this.log.debug((Object)("jbosstest.iterationcount=" + result));
        return result;
    }

    int getBeanCount() {
        int result = Integer.getInteger("jbosstest.beancount", 100);
        this.log.debug((Object)("jbosstest.beancount=" + result));
        return result;
    }

    public void init() throws Exception {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
            this.log.debug((Object)("initialContext.getEnvironment()=" + this.initialContext.getEnvironment()));
            this.jndiEnv = this.initialContext.getEnvironment();
        }
    }

    public void reinit() throws Exception {
        this.initialContext = null;
        this.server = null;
        this.init();
    }

    public String getServerHost() {
        String hostName = System.getProperty("jbosstest.server.host", "localhost");
        return hostName;
    }
}

