/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.report.impl.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.unit.Failure;
import org.jboss.unit.FailureType;
import org.jboss.unit.TestId;
import org.jboss.unit.report.impl.junit.AbstractJUnitReport;
import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.results.TestFailure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestsuiteReport
extends AbstractJUnitReport {
    public static final String TEST_FILE_NAME_PREFIX = "TEST-";
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final NumberFormat DURATION_FORMAT = NumberFormat.getInstance();
    private Document testsuitesDocument;
    private File htmlReportDir;
    private File xmlReportDir;
    private Map<TestSuiteKey, TestSuiteReport> reportMap = new HashMap<TestSuiteKey, TestSuiteReport>();

    public JUnitTestsuiteReport(File xmlReportDir, File htmlReportDir) {
        this.xmlReportDir = xmlReportDir;
        this.htmlReportDir = htmlReportDir;
    }

    @Override
    protected void startRunner() {
        this.testsuitesDocument = JUnitTestsuiteReport.createDocument();
    }

    @Override
    protected void endRunner() {
        Element testsuitesElement = this.testsuitesDocument.createElement("testsuites");
        this.testsuitesDocument.appendChild(testsuitesElement);
        int counter = 0;
        for (Map.Entry<TestSuiteKey, TestSuiteReport> entry : this.reportMap.entrySet()) {
            TestSuiteReport report = entry.getValue();
            if (report.elements.size() <= 0) continue;
            report.elements.add(this.testsuitesDocument.createElement("properties"));
            Element systemError = this.testsuitesDocument.createElement("system-err");
            systemError.appendChild(this.testsuitesDocument.createCDATASection(report.err.toString()));
            report.elements.add(systemError);
            Element systemOutElement = this.testsuitesDocument.createElement("system-out");
            systemOutElement.appendChild(this.testsuitesDocument.createCDATASection(report.out.toString()));
            report.elements.add(systemOutElement);
            Element testSuiteElt = this.testsuitesDocument.createElement("testsuite");
            testSuiteElt.setAttribute("hostname", JUnitTestsuiteReport.getHostName());
            testSuiteElt.setAttribute("package", entry.getKey().packageName);
            testSuiteElt.setAttribute("name", JUnitTestsuiteReport.appendURI(new StringBuffer(), entry.getKey().className, entry.getKey().properties).toString());
            testSuiteElt.setAttribute("tests", Integer.toString(report.tests));
            testSuiteElt.setAttribute("errors", Integer.toString(report.errors));
            testSuiteElt.setAttribute("failures", Integer.toString(report.failures));
            testSuiteElt.setAttribute("time", DURATION_FORMAT.format((double)report.durationMillis / 1000.0));
            for (Element elt : report.elements) {
                testSuiteElt.appendChild(elt);
            }
            if (this.xmlReportDir != null) {
                if (this.xmlReportDir.exists()) {
                    Document tmp = JUnitTestsuiteReport.createDocument();
                    Element copy = (Element)tmp.importNode(testSuiteElt, true);
                    tmp.appendChild(copy);
                    String a = copy.getAttribute("package");
                    String b = copy.getAttribute("name");
                    String c = a.length() == 0 ? b : a + "." + b;
                    copy.setAttribute("name", c);
                    copy.removeAttribute("package");
                    File f = new File(this.xmlReportDir, TEST_FILE_NAME_PREFIX + counter++ + ".xml");
                    try {
                        if (!f.exists()) {
                            f.createNewFile();
                        }
                        this.serializeNode(tmp, f);
                    }
                    catch (IOException e) {
                        System.out.println("Could not create file " + f.getAbsolutePath());
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("Cannot create report because parent dir " + this.xmlReportDir.getAbsolutePath() + " does not exist");
                }
            }
            testsuitesElement.appendChild(testSuiteElt);
        }
        if (this.htmlReportDir != null) {
            if (this.htmlReportDir.exists()) {
                try {
                    InputStream xslIn = this.getClass().getResourceAsStream("/org/jboss/unit/report/impl/junit/junit-frames.xsl");
                    DOMSource xmlSource = new DOMSource(testsuitesElement);
                    StreamSource xslSource = new StreamSource(xslIn);
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    Transformer trans = transFact.newTransformer(xslSource);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    StreamResult result = new StreamResult(os);
                    trans.setParameter("output.dir", this.htmlReportDir.getAbsolutePath());
                    trans.transform(xmlSource, result);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                File tmp = new File(this.htmlReportDir, "TESTS-TestSuites.xml");
                this.serializeNode(testsuitesElement, tmp);
            } else {
                System.out.println("Cannot create report because parent dir " + this.htmlReportDir.getAbsolutePath() + " does not exist");
            }
        }
    }

    @Override
    protected void runnerFailure(AbstractJUnitReport.TestSuite testSuite, Failure failure) {
        Element errorElt = this.testsuitesDocument.createElement("error");
        errorElt.setAttribute("type", failure.getType().name());
        errorElt.setAttribute("message", failure.getMessage());
        errorElt.appendChild(this.testsuitesDocument.createCDATASection(JUnitTestsuiteReport.stackToString(failure.getStackTrace())));
        this.get(testSuite).elements.add(errorElt);
    }

    @Override
    protected void startTestSuite(AbstractJUnitReport.TestSuite testSuite) {
    }

    private TestSuiteReport get(AbstractJUnitReport.TestSuite testSuite) {
        TestSuiteKey key = new TestSuiteKey(testSuite);
        TestSuiteReport report = this.reportMap.get(key);
        if (report == null) {
            report = new TestSuiteReport();
            this.reportMap.put(key, report);
        }
        return report;
    }

    @Override
    protected void endTestSuite(AbstractJUnitReport.TestSuite testSuite) {
        TestSuiteReport report = this.get(testSuite);
        if (testSuite.startedTests.size() > 0) {
            for (TestId id : testSuite.startedTests.keySet()) {
                Element errorNotEnded = this.testsuitesDocument.createElement("error");
                errorNotEnded.setAttribute("message", "Testcase: " + id + " was not ended properly. (No EndTestEvent)");
                report.elements.add(errorNotEnded);
            }
        }
        try {
            testSuite.view.writeTo(report.out, report.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        report.tests += testSuite.tests;
        report.failures += testSuite.failures;
        report.errors += testSuite.errors;
        report.durationMillis += testSuite.durationMillis;
    }

    private void serializeNode(Node node, File dest) {
        try {
            DOMSource source = new DOMSource(node);
            Transformer xtrans = TransformerFactory.newInstance().newTransformer();
            xtrans.setOutputProperty("indent", "yes");
            xtrans.setOutputProperty("method", "xml");
            xtrans.setOutputProperty("standalone", "yes");
            StreamResult result = new StreamResult(dest);
            xtrans.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static StringBuffer appendURI(StringBuffer buffer, String name, Map<String, String> parameters) {
        buffer.append(name);
        Iterator<String> i = parameters.keySet().iterator();
        if (i.hasNext()) {
            buffer.append("?");
            while (i.hasNext()) {
                String parameterName = i.next();
                String value = parameters.get(parameterName);
                buffer.append(parameterName).append("=").append(value);
                if (!i.hasNext()) continue;
                buffer.append("&");
            }
        }
        return buffer;
    }

    @Override
    protected void endTestCase(AbstractJUnitReport.TestSuite testSuite, String testName, TestResult result) {
        Element test = this.testsuitesDocument.createElement("testcase");
        test.setAttribute("classname", testSuite.getFQN().toString());
        test.setAttribute("name", JUnitTestsuiteReport.appendURI(new StringBuffer(), testName, result.getParametrization()).toString());
        test.setAttribute("time", DURATION_FORMAT.format((double)result.getDurationMillis() / 1000.0));
        if (result instanceof TestFailure) {
            String failureType;
            TestFailure testFailure = (TestFailure)result;
            Failure failure = testFailure.getFailure();
            if (FailureType.ASSERTION == failure.getType()) {
                ++testSuite.failures;
                failureType = "failure";
            } else {
                ++testSuite.errors;
                failureType = "error";
            }
            test.appendChild(this.addGeneralError(failureType, failure.getStackTrace()));
        }
        this.get(testSuite).elements.add(test);
    }

    private Element addGeneralError(String type, Throwable t) {
        Element error = this.testsuitesDocument.createElement(type);
        error.setAttribute("message", t.getMessage());
        error.setAttribute("type", t.getClass().getName());
        error.appendChild(this.testsuitesDocument.createCDATASection(JUnitTestsuiteReport.stackToString(t)));
        return error;
    }

    private static String stackToString(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        t.printStackTrace(printWriter);
        printWriter.close();
        return ((Object)writer).toString();
    }

    private static String createTimestamp() {
        return TIMESTAMP_FORMAT.format(new Date());
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    private static class TestSuiteReport {
        private final List<Element> elements = new ArrayList<Element>();
        private final StringWriter out = new StringWriter();
        private final StringWriter err = new StringWriter();
        private int tests;
        private int errors;
        private int failures;
        private long durationMillis;

        private TestSuiteReport() {
        }
    }

    private static class TestSuiteKey {
        private final String packageName;
        private final String className;
        private final Map<String, String> properties;

        private TestSuiteKey(AbstractJUnitReport.TestSuite testSuite) {
            StringBuffer fqn = testSuite.getFQN();
            int pos = fqn.lastIndexOf(".");
            this.packageName = pos == -1 ? "" : fqn.substring(0, pos);
            this.className = pos == -1 ? fqn.toString() : fqn.substring(pos + 1);
            this.properties = testSuite.properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestSuiteKey) {
                TestSuiteKey that = (TestSuiteKey)o;
                return that.packageName.equals(this.packageName) && that.className.equals(this.className) && ((Object)that.properties).equals(this.properties);
            }
            return false;
        }

        public int hashCode() {
            return this.packageName.hashCode() * 41 + this.className.hashCode();
        }
    }
}

