/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.report.impl.writer;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.unit.Failure;
import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.event.EndRunnerEvent;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.EndTestSuiteEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.event.StartTestSuiteEvent;
import org.jboss.unit.runner.results.TestFailure;
import org.jboss.unit.runner.results.TestSuccess;

public class PrintListener
implements TestRunnerEventListener {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private NumberFormat FORMAT = NumberFormat.getInstance();
    private final PrintWriter out;
    private LinkedList<SuiteStat> stack = new LinkedList();
    private String currentTestCaseName;

    public PrintListener() {
        this(System.out);
    }

    public PrintListener(Writer writer) throws IllegalArgumentException {
        if (writer == null) {
            throw new IllegalArgumentException();
        }
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
    }

    public PrintListener(OutputStream stream) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        this.out = new PrintWriter(stream, true);
    }

    public void onEvent(TestRunnerEvent event) {
        if (event instanceof StartRunnerEvent) {
            this.out.println("--- Start ---");
        } else if (event instanceof EndRunnerEvent) {
            this.out.println("--- End ---");
        } else if (event instanceof RunnerFailureEvent) {
            RunnerFailureEvent failureEvent = (RunnerFailureEvent)event;
            Failure failure = failureEvent.getFailure();
            this.out.println("Runner failure: " + failure.getType() + " " + failure.getMessage());
            failure.getCause().printStackTrace(this.out);
        } else if (event instanceof StartTestSuiteEvent) {
            StartTestSuiteEvent stse = (StartTestSuiteEvent)event;
            this.stack.add(new SuiteStat(stse.getTestInfo().getName()));
        } else if (event instanceof StartTestCaseEvent) {
            StartTestCaseEvent ste = (StartTestCaseEvent)event;
            this.currentTestCaseName = ste.getTestInfo().getName();
        } else if (event instanceof EndTestSuiteEvent) {
            StringBuffer tmp = new StringBuffer();
            Iterator i = this.stack.iterator();
            while (i.hasNext()) {
                SuiteStat stat = (SuiteStat)i.next();
                tmp.append(stat.name);
                if (!i.hasNext()) continue;
                tmp.append('.');
            }
            SuiteStat stat = this.stack.removeLast();
            StringBuffer sb = new StringBuffer("Testsuite: ");
            sb.append(tmp);
            sb.append(NEW_LINE);
            if (stat.count > 0) {
                sb.append("Tests run: ");
                sb.append(stat.count);
                sb.append(", Failures: ");
                sb.append(stat.failures);
                sb.append(", Errors: ");
                sb.append(stat.errors);
                sb.append(", Time elapsed: ");
                sb.append(this.FORMAT.format((double)(System.currentTimeMillis() - stat.timestamp) / 1000.0));
                sb.append(" sec");
            } else {
                sb.append("Testcase skipped...");
            }
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            this.out.print(sb);
        } else if (event instanceof EndTestCaseEvent) {
            this.stack.getLast().count++;
            EndTestCaseEvent endTestEvent = (EndTestCaseEvent)event;
            TestResult testResult = endTestEvent.getTestResult();
            StringBuffer name = new StringBuffer(this.currentTestCaseName);
            Map<String, String> parametrization = testResult.getParametrization();
            if (!parametrization.isEmpty()) {
                name.append('?');
                Iterator<Map.Entry<String, String>> i = parametrization.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, String> entry = i.next();
                    name.append((Object)entry.getKey()).append('=').append((Object)entry.getValue());
                    if (!i.hasNext()) continue;
                    name.append('&');
                }
            }
            this.out.println("Testcase:  " + name + " took " + this.FORMAT.format((double)testResult.getDurationMillis() / 1000.0) + " sec");
            if (!(testResult instanceof TestSuccess) && testResult instanceof TestFailure) {
                TestFailure testFailure = (TestFailure)testResult;
                Failure failure = testFailure.getFailure();
                switch (failure.getType()) {
                    case ASSERTION: {
                        this.out.println("\tFAILED");
                        this.stack.getLast().failures++;
                        break;
                    }
                    case ERROR: {
                        this.out.println("\tCaused an ERROR");
                        this.stack.getLast().errors++;
                    }
                }
                this.out.print(failure.getMessage());
                if (failure.getCause() != null) {
                    failure.getCause().printStackTrace(this.out);
                }
                this.out.println();
            }
        }
    }

    private static class SuiteStat {
        private final String name;
        private int failures = 0;
        private int errors = 0;
        private int count = 0;
        private long timestamp = System.currentTimeMillis();

        private SuiteStat(String name) {
            this.name = name;
        }
    }
}

