/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsFrame;
import org.apache.tomcat.util.buf.EncodingToCharset;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaMessages;

public class WsOutbound {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private HttpEvent event;
    private StreamInbound streamInbound;
    private ByteBuffer bb;
    private CharBuffer cb;
    private boolean closed = false;
    private Boolean text = null;
    private boolean firstFrame = true;

    public WsOutbound(HttpEvent event, StreamInbound streamInbound) {
        this(event, streamInbound, 8192, 8192);
    }

    public WsOutbound(HttpEvent event, StreamInbound streamInbound, int byteBufferSize, int charBufferSize) {
        this.event = event;
        this.streamInbound = streamInbound;
        this.bb = ByteBuffer.allocate(byteBufferSize);
        this.cb = CharBuffer.allocate(charBufferSize);
    }

    public synchronized void writeBinaryData(int b) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        if (this.bb.position() == this.bb.capacity()) {
            this.doFlush(false);
        }
        if (this.text == null) {
            this.text = Boolean.FALSE;
        } else if (this.text == Boolean.TRUE) {
            this.flush();
            this.text = Boolean.FALSE;
        }
        this.bb.put((byte)(b & 0xFF));
    }

    public synchronized void writeTextData(char c) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        if (this.cb.position() == this.cb.capacity()) {
            this.doFlush(false);
        }
        if (this.text == null) {
            this.text = Boolean.TRUE;
        } else if (this.text == Boolean.FALSE) {
            this.flush();
            this.text = Boolean.TRUE;
        }
        this.cb.append(c);
    }

    public synchronized void writeBinaryMessage(ByteBuffer msgBb) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        if (this.text != null) {
            this.flush();
        }
        this.text = Boolean.FALSE;
        this.doWriteBytes(msgBb, true);
    }

    public synchronized void writeTextMessage(CharBuffer msgCb) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        if (this.text != null) {
            this.flush();
        }
        this.text = Boolean.TRUE;
        this.doWriteText(msgCb, true);
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        this.doFlush(true);
    }

    private void doFlush(boolean finalFragment) throws IOException {
        if (this.text == null) {
            return;
        }
        if (this.text.booleanValue()) {
            this.cb.flip();
            this.doWriteText(this.cb, finalFragment);
        } else {
            this.bb.flip();
            this.doWriteBytes(this.bb, finalFragment);
        }
    }

    protected void close(WsFrame frame) throws IOException {
        if (frame.getPayLoadLength() > 0L) {
            if (frame.getPayLoadLength() == 1L) {
                throw new IOException();
            }
            int status = (frame.getPayLoad().get() & 0xFF) << 8;
            if (this.validateCloseStatus(status += frame.getPayLoad().get() & 0xFF)) {
                this.close(status, frame.getPayLoad());
            } else {
                this.close(1002, null);
            }
        } else {
            this.close(0, null);
        }
    }

    private boolean validateCloseStatus(int status) {
        return status == 1000 || status == 1001 || status == 1002 || status == 1003 || status == 1007 || status == 1008 || status == 1009 || status == 1010 || status == 1011 || status > 2999 && status < 5000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int status, ByteBuffer data) throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.doFlush(false);
        }
        finally {
            this.closed = true;
        }
        ServletOutputStream os = this.event.getHttpServletResponse().getOutputStream();
        os.write(136);
        if (status == 0) {
            os.write(0);
        } else if (data == null || data.position() == data.limit()) {
            os.write(2);
            os.write(status >>> 8);
            os.write(status);
        } else {
            os.write(2 + data.limit() - data.position());
            os.write(status >>> 8);
            os.write(status);
            os.write(data.array(), data.position(), data.limit() - data.position());
        }
        os.flush();
        this.bb = null;
        this.cb = null;
    }

    public synchronized void pong(ByteBuffer data) throws IOException {
        this.sendControlMessage(data, (byte)10);
    }

    public synchronized void ping(ByteBuffer data) throws IOException {
        this.sendControlMessage(data, (byte)9);
    }

    private synchronized void sendControlMessage(ByteBuffer data, byte opcode) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        this.doFlush(false);
        ServletOutputStream os = this.event.getHttpServletResponse().getOutputStream();
        os.write(0x80 | opcode);
        if (data == null) {
            os.write(0);
        } else {
            os.write(data.limit() - data.position());
            os.write(data.array(), data.position(), data.limit() - data.position());
        }
        os.flush();
    }

    private void doWriteBytes(ByteBuffer buffer, boolean finalFragment) throws IOException {
        if (this.closed) {
            throw new IOException(CatalinaMessages.MESSAGES.outboundClosed());
        }
        try {
            int first = 0;
            if (finalFragment) {
                first += 128;
            }
            if (this.firstFrame) {
                first = this.text.booleanValue() ? ++first : (first += 2);
            }
            ServletOutputStream os = this.event.getHttpServletResponse().getOutputStream();
            os.write(first);
            if (buffer.limit() < 126) {
                os.write(buffer.limit());
            } else if (buffer.limit() < 65536) {
                os.write(126);
                os.write(buffer.limit() >>> 8);
                os.write(buffer.limit() & 0xFF);
            } else {
                os.write(127);
                os.write(0);
                os.write(0);
                os.write(0);
                os.write(0);
                os.write(buffer.limit() >>> 24);
                os.write(buffer.limit() >>> 16);
                os.write(buffer.limit() >>> 8);
                os.write(buffer.limit() & 0xFF);
            }
            os.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
            os.flush();
            if (finalFragment) {
                this.text = null;
                this.firstFrame = true;
            } else {
                this.firstFrame = false;
            }
            this.bb.clear();
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    private void doWriteText(CharBuffer buffer, boolean finalFragment) throws IOException {
        CharsetEncoder encoder = EncodingToCharset.UTF_8.newEncoder();
        do {
            CoderResult cr;
            if ((cr = encoder.encode(buffer, this.bb, true)).isError()) {
                cr.throwException();
            }
            this.bb.flip();
            if (buffer.hasRemaining()) {
                this.doWriteBytes(this.bb, false);
                continue;
            }
            this.doWriteBytes(this.bb, finalFragment);
        } while (buffer.hasRemaining());
        this.cb.clear();
    }
}

