/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.util.BitSet;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public final class UEncoder {
    private BitSet safeChars = null;
    private C2BConverter c2b = null;
    private ByteChunk bb = null;
    private CharChunk cb = null;
    private CharChunk output = null;
    private String encoding = "UTF8";

    public UEncoder() {
        this.initSafeChars();
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void addSafeCharacter(char c) {
        this.safeChars.set(c);
    }

    public CharChunk encodeURL(String s, int start, int end) throws IOException {
        if (this.c2b == null) {
            this.bb = new ByteChunk(8);
            this.cb = new CharChunk(2);
            this.output = new CharChunk(64);
            this.c2b = new C2BConverter(this.encoding);
        } else {
            this.bb.recycle();
            this.cb.recycle();
        }
        for (int i = start; i < end; ++i) {
            char d;
            char c = s.charAt(i);
            if (this.safeChars.get(c)) {
                this.output.append(c);
                continue;
            }
            this.cb.append(c);
            this.c2b.convert(this.cb, this.bb);
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < end && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                this.cb.append(d);
                this.c2b.convert(this.cb, this.bb);
                ++i;
            }
            this.urlEncode(this.output, this.bb);
            this.cb.recycle();
            this.bb.recycle();
        }
        return this.output;
    }

    protected void urlEncode(CharChunk out, ByteChunk bb) throws IOException {
        byte[] bytes = bb.getBuffer();
        for (int j = bb.getStart(); j < bb.getEnd(); ++j) {
            out.append('%');
            char ch = Character.forDigit(bytes[j] >> 4 & 0xF, 16);
            out.append(ch);
            ch = Character.forDigit(bytes[j] & 0xF, 16);
            out.append(ch);
        }
    }

    private void initSafeChars() {
        int i;
        this.safeChars = new BitSet(128);
        for (i = 97; i <= 122; ++i) {
            this.safeChars.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            this.safeChars.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            this.safeChars.set(i);
        }
        this.safeChars.set(36);
        this.safeChars.set(45);
        this.safeChars.set(95);
        this.safeChars.set(46);
        this.safeChars.set(33);
        this.safeChars.set(42);
        this.safeChars.set(39);
        this.safeChars.set(40);
        this.safeChars.set(41);
        this.safeChars.set(44);
    }
}

