/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.web.CoyoteLogger;

public class HttpMessages {
    protected static Properties statusMessages = new Properties();
    static String st_200;
    static String st_302;
    static String st_400;
    static String st_404;

    public static String getMessage(int status) {
        switch (status) {
            case 200: {
                if (st_200 == null) {
                    st_200 = statusMessages.getProperty("sc.200");
                }
                return st_200;
            }
            case 302: {
                if (st_302 == null) {
                    st_302 = statusMessages.getProperty("sc.302");
                }
                return st_302;
            }
            case 400: {
                if (st_400 == null) {
                    st_400 = statusMessages.getProperty("sc.400");
                }
                return st_400;
            }
            case 404: {
                if (st_404 == null) {
                    st_404 = statusMessages.getProperty("sc.404");
                }
                return st_404;
            }
        }
        return statusMessages.getProperty("sc." + status);
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = HttpMessages.class.getClassLoader().getResourceAsStream("org/apache/tomcat/util/http/HttpMessages.properties");
            statusMessages.load(is);
        }
        catch (Exception e) {
            CoyoteLogger.HTTP_LOGGER.errorLoadingMessages(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        st_200 = null;
        st_302 = null;
        st_400 = null;
        st_404 = null;
    }
}

