/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.Hashtable;
import org.apache.tomcat.util.net.DefaultNioServerSocketChannelFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.jsse.NioJSSESocketChannelFactory;

public abstract class NioServerSocketChannelFactory
implements Cloneable {
    private static NioServerSocketChannelFactory theFactory;
    protected Hashtable<String, Object> attributes = new Hashtable();
    protected AsynchronousChannelGroup threadGroup;
    protected boolean internalExecutor = true;

    protected NioServerSocketChannelFactory() {
    }

    protected NioServerSocketChannelFactory(AsynchronousChannelGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public abstract void init() throws IOException;

    public abstract void destroy() throws IOException;

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public static synchronized NioServerSocketChannelFactory getDefault() {
        return NioServerSocketChannelFactory.getDefault(null);
    }

    public static synchronized NioServerSocketChannelFactory getDefault(AsynchronousChannelGroup threadGroup) {
        if (theFactory == null) {
            theFactory = new DefaultNioServerSocketChannelFactory(threadGroup);
        } else if (NioServerSocketChannelFactory.theFactory.threadGroup != threadGroup) {
            theFactory = new DefaultNioServerSocketChannelFactory(threadGroup);
        }
        try {
            return (NioServerSocketChannelFactory)theFactory.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static synchronized NioServerSocketChannelFactory createSecureFactory(AsynchronousChannelGroup threadGroup) {
        return new NioJSSESocketChannelFactory(threadGroup);
    }

    public static synchronized NioServerSocketChannelFactory createServerSocketChannelFactory(AsynchronousChannelGroup threadGroup, boolean secure) {
        return secure ? NioServerSocketChannelFactory.createSecureFactory(threadGroup) : NioServerSocketChannelFactory.getDefault(threadGroup);
    }

    public AsynchronousServerSocketChannel createServerChannel(int port) throws IOException {
        return this.createServerChannel(port, -1);
    }

    public AsynchronousServerSocketChannel createServerChannel(int port, int backlog) throws IOException {
        return this.createServerChannel(port, backlog, null, false, true);
    }

    public abstract AsynchronousServerSocketChannel createServerChannel(int var1, int var2, InetAddress var3, boolean var4, boolean var5) throws IOException;

    public abstract void initChannel(NioChannel var1) throws Exception;

    public abstract NioChannel acceptChannel(AsynchronousServerSocketChannel var1) throws IOException;

    public abstract void handshake(NioChannel var1) throws IOException;

    protected AsynchronousServerSocketChannel open() throws IOException {
        return AsynchronousServerSocketChannel.open(this.threadGroup);
    }
}

