/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.ConcurrentHashMapBeanStore;

public abstract class AbstractSharedContext
extends AbstractContext {
    private final Singleton<BeanStore> beanStore = SingletonProvider.instance().create(BeanStore.class);

    protected AbstractSharedContext() {
        super(true);
        this.beanStore.set(new ConcurrentHashMapBeanStore());
    }

    public BeanStore getBeanStore() {
        return this.beanStore.get();
    }

    public boolean isActive() {
        return true;
    }

    public void invalidate() {
        this.destroy();
    }

    protected void destroy() {
        super.destroy();
        this.cleanup();
    }

    public void cleanup() {
        super.cleanup();
        this.beanStore.clear();
    }

    public String toString() {
        String active = this.isActive() ? "Active " : "Inactive ";
        String beanStoreInfo = this.getBeanStore() == null ? "" : this.getBeanStore().toString();
        return active + "application context " + beanStoreInfo;
    }
}

