/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated;

import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.MetadataMessage;

public class AnnotatedTypeValidator {
    private AnnotatedTypeValidator() {
    }

    public static void validateAnnotated(Annotated annotated) {
        AnnotatedTypeValidator.checkNotNull(annotated.getAnnotations(), "getAnnotations()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getBaseType(), "getBaseType()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getTypeClosure(), "getTypeClosure()", annotated);
    }

    public static void validateAnnotatedParameter(AnnotatedParameter<?> parameter) {
        AnnotatedTypeValidator.validateAnnotated(parameter);
        if (parameter.getPosition() < 0) {
            throw new IllegalArgumentException(MetadataMessage.INVALID_PARAMETER_POSITION, parameter.getPosition(), parameter);
        }
        AnnotatedTypeValidator.checkNotNull(parameter.getDeclaringCallable(), "getDeclaringCallable()", parameter);
    }

    public static void validateAnnotatedMember(AnnotatedMember<?> member) {
        AnnotatedTypeValidator.validateAnnotated(member);
        AnnotatedTypeValidator.checkNotNull(member.getJavaMember(), "getJavaMember()", member);
        AnnotatedTypeValidator.checkNotNull(member.getDeclaringType(), "getDeclaringType()", member);
    }

    public static void validateAnnotatedType(AnnotatedType<?> type) {
        AnnotatedTypeValidator.validateAnnotated(type);
        AnnotatedTypeValidator.checkNotNull(type.getJavaClass(), "getJavaClass()", type);
        AnnotatedTypeValidator.checkNotNull(type.getFields(), "getFields()", type);
        AnnotatedTypeValidator.checkNotNull(type.getConstructors(), "getConstructors()", type);
        AnnotatedTypeValidator.checkNotNull(type.getMethods(), "getMethods()", type);
    }

    private static void checkNotNull(Object expression, String methodName, Object target) {
        if (expression == null) {
            throw new IllegalArgumentException(MetadataMessage.METADATA_SOURCE_RETURNED_NULL, methodName, target);
        }
    }
}

