/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.util.reflection.Reflections;

public class SlimAnnotatedTypeStoreImpl
implements SlimAnnotatedTypeStore,
Service {
    private final ConcurrentMap<Class<?>, Set<SlimAnnotatedType<?>>> typesByClass = new MapMaker().makeComputingMap(new Function<Class<?>, Set<SlimAnnotatedType<?>>>(){

        @Override
        public Set<SlimAnnotatedType<?>> apply(Class<?> input) {
            return new CopyOnWriteArraySet();
        }
    });

    @Override
    public <X> SlimAnnotatedType<X> get(Class<X> type, String suffix) {
        for (SlimAnnotatedType annotatedType : this.get((Class)type)) {
            if (!Objects.equal(((AnnotatedTypeIdentifier)annotatedType.getIdentifier()).getSuffix(), suffix)) continue;
            return annotatedType;
        }
        return null;
    }

    public <X> Set<SlimAnnotatedType<X>> get(Class<X> type) {
        return (Set)Reflections.cast(Collections.unmodifiableSet((Set)this.typesByClass.get(type)));
    }

    @Override
    public <X> void put(SlimAnnotatedType<X> type) {
        ((Set)this.typesByClass.get(type.getJavaClass())).add(type);
    }

    @Override
    public void cleanup() {
        this.typesByClass.clear();
    }
}

