/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.resolution.Resolvable;

public class EventPacket<T>
implements EventMetadata {
    private final T payload;
    private final Type type;
    private final Resolvable resolvable;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifierSet;
    private final Annotation[] qualifierArray;

    public static <T> EventPacket<T> of(T event, Type eventType, Resolvable resolvable, Set<Annotation> qualifiers, InjectionPoint ip) {
        return new EventPacket<T>(event, eventType, qualifiers, null, resolvable, ip);
    }

    public static <T> EventPacket<T> of(T event, Resolvable resolvable, Annotation ... qualifiers) {
        return new EventPacket<T>(event, event.getClass(), null, qualifiers, resolvable, null);
    }

    private EventPacket(T payload, Type type, Set<Annotation> qualifierSet, Annotation[] qualifierArray, Resolvable resolvable, InjectionPoint injectionPoint) {
        this.payload = payload;
        this.type = type;
        this.qualifierSet = qualifierSet;
        this.qualifierArray = qualifierArray;
        this.resolvable = resolvable;
        this.injectionPoint = injectionPoint;
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(AnyLiteral.INSTANCE);
        if (this.qualifierSet != null) {
            return ((ImmutableSet.Builder)builder.addAll(this.qualifierSet)).build();
        }
        if (this.qualifierArray != null) {
            return ((ImmutableSet.Builder)builder.add(this.qualifierArray)).build();
        }
        throw new IllegalStateException();
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public Resolvable getResolvable() {
        return this.resolvable;
    }

    public String toString() {
        return "EventPacket [payload=" + this.payload + ", type=" + this.type + ", qualifiers=" + this.getQualifiers() + "]";
    }
}

