/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.InjectionPoints;

public class DefaultInjector<T>
implements Injector<T> {
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;

    public DefaultInjector(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        this.injectableFields = InjectionPointFactory.instance().getFieldInjectionPoints(bean, type, beanManager);
        this.initializerMethods = BeanMethods.getInitializerMethods(bean, type, beanManager);
    }

    @Override
    public void registerInjectionPoints(Set<InjectionPoint> injectionPoints) {
        injectionPoints.addAll(InjectionPoints.flattenInjectionPoints(this.injectableFields));
        injectionPoints.addAll(InjectionPoints.flattenParameterInjectionPoints(this.initializerMethods));
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx, final BeanManagerImpl manager, SlimAnnotatedType<T> type, InjectionTarget<T> injectionTarget) {
        new InjectionContextImpl<T>(manager, injectionTarget, type, instance){

            @Override
            public void proceed() {
                DefaultInjector.this.inject(instance, ctx, manager);
            }
        }.run();
    }

    public void inject(T instance, CreationalContext<T> ctx, BeanManagerImpl manager) {
        Beans.injectFieldsAndInitializers(instance, ctx, manager, this.injectableFields, this.initializerMethods);
    }

    @Override
    public List<Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    @Override
    public List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }
}

