/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.apache.maven.index.ArtifactInfo;
import org.jboss.windup.maven.nexusindexer.ArtifactFilter;
import org.jboss.windup.maven.nexusindexer.RepositoryIndexManager;

public class LuceneIndexArtifactVisitor
implements RepositoryIndexManager.ArtifactVisitor<Object> {
    private static final Logger LOG = Logger.getLogger(LuceneIndexArtifactVisitor.class.getName());
    public static final String ARCHIVE_METADATA_INDEX_DIR_MARKER = "archive-metadata.lucene.marker";
    private final ArtifactFilter filter;
    private final File indexDir;
    private final IndexWriter indexWriter;
    private SimpleFSDirectory luceneOutputDirResource;
    public static final String SHA1 = "sha1";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String PACKAGING = "packaging";
    public static final String CLASSIFIER = "classifier";
    public static final String VERSION = "version";

    public LuceneIndexArtifactVisitor(File outputDir, ArtifactFilter filter) {
        try {
            this.filter = filter;
            this.indexDir = outputDir;
            this.indexDir.mkdirs();
            File markerFile = new File(this.indexDir, LuceneIndexArtifactVisitor.getLuceneIndexDirMarkerFileName());
            FileUtils.write((File)markerFile, (CharSequence)"This file is searched by Windup to locate the Lucene index with repository metadata.");
            this.luceneOutputDirResource = new SimpleFSDirectory(this.indexDir);
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_48);
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_48, (Analyzer)standardAnalyzer);
            this.indexWriter = new IndexWriter((Directory)this.luceneOutputDirResource, config);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed creating Lucene index writer in: " + outputDir + "\n    " + ex.getMessage(), ex);
        }
    }

    public static String getLuceneIndexDirMarkerFileName() {
        return ARCHIVE_METADATA_INDEX_DIR_MARKER;
    }

    @Override
    public void visit(ArtifactInfo artifact) {
        if (!this.filter.accept(artifact)) {
            return;
        }
        try {
            this.indexWriter.addDocuments(this.artifactToDocs(artifact));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed writing to IndexWriter: " + ex.getMessage(), ex);
        }
    }

    protected Iterable<Document> artifactToDocs(ArtifactInfo artifact) {
        Document outputDoc = new Document();
        outputDoc.add((IndexableField)new StringField(SHA1, artifact.getSha1(), Field.Store.YES));
        outputDoc.add((IndexableField)new StringField(GROUP_ID, artifact.getGroupId(), Field.Store.YES));
        outputDoc.add((IndexableField)new StringField(ARTIFACT_ID, artifact.getArtifactId(), Field.Store.YES));
        outputDoc.add((IndexableField)new StringField(PACKAGING, artifact.getPackaging(), Field.Store.YES));
        outputDoc.add((IndexableField)new StringField(CLASSIFIER, artifact.getClassifier(), Field.Store.YES));
        outputDoc.add((IndexableField)new StringField(VERSION, artifact.getVersion(), Field.Store.YES));
        return Collections.singleton(outputDoc);
    }

    @Override
    public Object done() {
        try {
            this.indexWriter.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed closing Lucene index writer in: " + this.indexDir + "\n    " + ex.getMessage(), ex);
        }
        finally {
            this.luceneOutputDirResource.close();
        }
        return null;
    }
}

