/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.windup.maven.nexusindexer.ArtifactFilter;
import org.jboss.windup.maven.nexusindexer.BomBasedArtifactFilterFactory;
import org.jboss.windup.maven.nexusindexer.LoggingTransferListener;
import org.jboss.windup.maven.nexusindexer.LuceneIndexArtifactVisitor;
import org.jboss.windup.maven.nexusindexer.SortingLineWriterArtifactVisitor;

public class RepositoryIndexManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(RepositoryIndexManager.class.getName());
    private static final String JBOSS_PARENT_20 = "org.jboss:jboss-parent:20";
    private static final String BOM_EAP7_TOOLS = "org.jboss.bom:jboss-javaee-7.0-eap-with-tools:7.0.0-SNAPSHOT";
    private static final String BOM_EAP7 = "org.jboss.bom:jboss-eap-javaee7:7.0.0-SNAPSHOT";
    public static final String LUCENE_SUBDIR_CHECKSUMS = "lucene";
    public static final String LUCENE_SUBDIR_PACKAGES = "lucene-packages";
    private final File indexDirectory;
    private final PlexusContainer plexusContainer;
    private final Indexer indexer;
    private final IndexUpdater indexUpdater;
    private final Wagon httpWagon;
    private final IndexingContext context;
    private final File localCache;
    private final File indexDir;

    public static void generateMetadata(DependencyRepository repository, File indexDir, File outputDir, OutputFormat format) throws Exception {
        try (RepositoryIndexManager manager = new RepositoryIndexManager(indexDir, repository);){
            LOG.info("Downloading or updating index into " + indexDir.getPath());
            manager.downloadIndexAndUpdate();
            LOG.info("Writing selected Nexus index data to " + outputDir.getPath());
            manager.writeMetadataTo(outputDir, repository, format);
        }
    }

    public static boolean metadataExists(DependencyRepository repository, File outputDir) {
        return RepositoryIndexManager.getMetadataFile(repository, outputDir).exists();
    }

    public static File getMetadataFile(DependencyRepository repository, File outputDir) {
        return new File(outputDir, repository.getId() + ".archive-metadata.txt");
    }

    private RepositoryIndexManager(File indexDirectory, DependencyRepository repository) throws PlexusContainerException, ComponentLookupException, IOException {
        boolean updateExistingIndex = true;
        this.indexDirectory = indexDirectory;
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
        this.httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        this.localCache = new File(this.indexDirectory, repository.getId() + "-cache");
        this.indexDir = new File(this.indexDirectory, repository.getId() + "-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "min"));
        this.context = this.indexer.createIndexingContext(repository.getId() + "Context", repository.getId(), this.localCache, this.indexDir, repository.getUrl(), null, true, true, indexers);
    }

    private void downloadIndexAndUpdate() throws IOException {
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(this.httpWagon, (TransferListener)new LoggingTransferListener(LOG), null, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.context, (ResourceFetcher)resourceFetcher);
        updateRequest.setIncrementalOnly(false);
        updateRequest.setForceFullUpdate(false);
        IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            LOG.info("Fully updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        } else {
            LOG.info("Incrementally updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        }
    }

    private void writeMetadataTo(File outDir, DependencyRepository repository, OutputFormat outputFormat) throws IOException {
        outDir.mkdirs();
        IndexSearcher searcher = this.context.acquireIndexSearcher();
        IndexReader reader = searcher.getIndexReader();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        File textMetadataFile = RepositoryIndexManager.getMetadataFile(repository, outDir);
        ArrayList<ArtifactVisitor<Object>> visitors = new ArrayList<ArtifactVisitor<Object>>();
        if (outputFormat.equals((Object)OutputFormat.TEXT)) {
            SortingLineWriterArtifactVisitor writerVisitor = new SortingLineWriterArtifactVisitor(textMetadataFile, ArtifactFilter.LIBRARIES);
            visitors.add(writerVisitor);
        } else if (outputFormat.equals((Object)OutputFormat.LUCENE)) {
            LuceneIndexArtifactVisitor basicIndexerVisitor = new LuceneIndexArtifactVisitor(new File(outDir, LUCENE_SUBDIR_CHECKSUMS), ArtifactFilter.LIBRARIES);
            visitors.add(basicIndexerVisitor);
        }
        ArtifactFilter bomFilter = new BomBasedArtifactFilterFactory().createArtifactFilterFromBom(BOM_EAP7_TOOLS);
        ArtifactFilter.AndFilter libsBomFilter = new ArtifactFilter.AndFilter(ArtifactFilter.LIBRARIES, bomFilter);
        for (int i = 0; i < reader.maxDoc(); ++i) {
            Document document;
            ArtifactInfo artifact;
            if (liveDocs != null && !liveDocs.get(i) || (artifact = IndexUtils.constructArtifactInfo((Document)(document = reader.document(i)), (IndexingContext)this.context)) == null) continue;
            artifact.setSha1(StringUtils.lowerCase((String)artifact.getSha1()));
            artifact.setPackaging(StringUtils.defaultString((String)artifact.getPackaging()));
            artifact.setClassifier(StringUtils.defaultString((String)artifact.getClassifier()));
            for (ArtifactVisitor artifactVisitor : visitors) {
                try {
                    artifactVisitor.visit(artifact);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed processing " + artifact + " with " + artifactVisitor + "\n    " + e.getMessage());
                }
            }
        }
        for (ArtifactVisitor artifactVisitor : visitors) {
            try {
                artifactVisitor.done();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed finishing " + artifactVisitor, e);
            }
        }
        this.context.releaseIndexSearcher(searcher);
    }

    @Override
    public void close() throws IOException {
        this.context.close(false);
        this.indexer.closeIndexingContext(this.context, false);
    }

    public static interface ArtifactVisitor<T> {
        public void visit(ArtifactInfo var1);

        public T done();
    }

    public static enum OutputFormat {
        TEXT,
        LUCENE;

    }
}

