/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipUtil {
    public static void scanClassesInJar(Path zipFilePath, boolean packagesOnly, Visitor<String> onClassFound) throws IOException {
        try (FileInputStream is = new FileInputStream(zipFilePath.toFile());){
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(is);
                String lastPackageSubpath = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String subPath = entry.getName();
                    if (!subPath.endsWith(".class")) continue;
                    if (packagesOnly) {
                        String packageSubpath = StringUtils.substringBeforeLast((String)subPath, (String)"/");
                        if (packageSubpath.equals(lastPackageSubpath)) continue;
                        lastPackageSubpath = packageSubpath;
                        onClassFound.visit(packageSubpath.replace('/', '.'));
                        continue;
                    }
                    String qualifiedName = ZipUtil.classFilePathToClassname(subPath);
                    onClassFound.visit(qualifiedName);
                }
            }
            catch (IOException ex) {
                throw new IOException("Could not read ZIP file: " + zipFilePath + " Due to: " + ex.getMessage());
            }
        }
    }

    public static String classFilePathToClassname(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        int pos = relativePath.lastIndexOf(".class");
        if (pos < 0 && relativePath.lastIndexOf(".java") < 0) {
            throw new IllegalArgumentException("Not a .class/.java file path: " + relativePath);
        }
        if ((relativePath = FilenameUtils.separatorsToUnix((String)relativePath)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.startsWith("src/main/java/")) {
            relativePath = relativePath.substring("src/main/java/".length());
        }
        if (relativePath.startsWith("WEB-INF/classes/")) {
            relativePath = relativePath.substring("WEB-INF/classes/".length());
        }
        if (relativePath.startsWith("WEB-INF/classes.jdk15/")) {
            relativePath = relativePath.substring("WEB-INF/classes.jdk15/".length());
        }
        if (relativePath.endsWith(".class")) {
            relativePath = relativePath.substring(0, relativePath.length() - ".class".length());
        } else if (relativePath.endsWith(".java")) {
            relativePath = relativePath.substring(0, relativePath.length() - ".java".length());
        }
        String qualifiedName = relativePath.replace("/", ".");
        return qualifiedName;
    }

    public static interface Visitor<T> {
        public void visit(T var1);
    }
}

