/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;

public class InterceptorUtils {
    public static void addInterceptors(InterceptorProvider interceptorProvider, Map<String, String> properties) {
        String outInterceptors;
        String inInterceptors = properties.get("cxf.interceptors.in");
        if (inInterceptors != null) {
            interceptorProvider.getInInterceptors().addAll(InterceptorUtils.createInterceptors(inInterceptors));
        }
        if ((outInterceptors = properties.get("cxf.interceptors.out")) != null) {
            interceptorProvider.getOutInterceptors().addAll(InterceptorUtils.createInterceptors(outInterceptors));
        }
    }

    public static void removeInterceptors(List<Interceptor<?>> interceptorsList, String interceptors) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(interceptors, ", ", false);
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        ArrayList toBeRemoved = new ArrayList();
        for (Interceptor interceptor : interceptorsList) {
            if (!set.contains(interceptor.getClass().getName())) continue;
            toBeRemoved.add(interceptor);
        }
        interceptorsList.removeAll(toBeRemoved);
    }

    private static List<Interceptor<?>> createInterceptors(String propValue) {
        ArrayList list = new ArrayList();
        StringTokenizer st = new StringTokenizer(propValue, ", ", false);
        while (st.hasMoreTokens()) {
            String itc = st.nextToken();
            Interceptor interceptor = (Interceptor)InterceptorUtils.newInstance(itc);
            if (interceptor == null) continue;
            list.add(interceptor);
        }
        return list;
    }

    private static Object newInstance(String className) {
        try {
            DelegateClassLoader loader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
            Class<?> clazz = SecurityActions.loadClass((ClassLoader)loader, className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

