/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringConfigurer;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityProviderConfig;
import org.jboss.wsf.stack.cxf.client.injection.JBossWSResourceInjectionResolver;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class JBossWSSpringBusFactory
extends SpringBusFactory {
    private boolean customContextProvided = false;

    public JBossWSSpringBusFactory() {
    }

    public JBossWSSpringBusFactory(ApplicationContext context) {
        super(context);
        this.customContextProvided = context != null;
    }

    public Bus createBus(String[] cfgFiles, boolean includeDefaults) {
        try {
            String userCfgFile = SecurityActions.getSystemProperty("cxf.config.file", null);
            String sysCfgFileUrl = SecurityActions.getSystemProperty("cxf.config.file.url", null);
            Resource r = BusApplicationContext.findResource((String)"cxf.xml");
            if (!(this.customContextProvided || userCfgFile != null || cfgFiles != null || sysCfgFileUrl != null || r != null && r.exists() || !includeDefaults)) {
                return new JBossWSNonSpringBusFactory().createBus();
            }
            return this.finishCreatingBus(this.createApplicationContext(cfgFiles, includeDefaults));
        }
        catch (BeansException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Bus createBus(URL[] urls, boolean includeDefaults) {
        try {
            return this.finishCreatingBus(new BusApplicationContext(urls, includeDefaults, this.getApplicationContext()));
        }
        catch (BeansException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Bus finishCreatingBus(BusApplicationContext bac) {
        Bus bus = (Bus)bac.getBean("cxf");
        bus.setExtension((Object)bac, BusApplicationContext.class);
        this.setConfigurer(bus);
        JBossWSSpringBusFactory.possiblySetDefaultBus((Bus)bus);
        this.initializeBus(bus);
        this.registerAppContextLifeCycleListener(bus, bac);
        return bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BusApplicationContext createApplicationContext(String[] cfgFiles, boolean includeDefaults) {
        try {
            return new BusApplicationContext(cfgFiles, includeDefaults, this.getApplicationContext());
        }
        catch (BeansException ex) {
            ClassLoader contextLoader = SecurityActions.getContextClassLoader();
            if (contextLoader != BusApplicationContext.class.getClassLoader()) {
                Loggers.ROOT_LOGGER.appContextCreationFailedWillTryWithNewTCCL(contextLoader, BusApplicationContext.class.getClassLoader(), ex);
                SecurityActions.setContextClassLoader(BusApplicationContext.class.getClassLoader());
                try {
                    BusApplicationContext busApplicationContext = new BusApplicationContext(cfgFiles, includeDefaults, this.getApplicationContext());
                    return busApplicationContext;
                }
                finally {
                    SecurityActions.setContextClassLoader(contextLoader);
                }
            }
            throw ex;
        }
    }

    private void setConfigurer(Bus bus) {
        JBossWSSpringConfigurer configurer = new JBossWSSpringConfigurer((Configurer)bus.getExtension(Configurer.class));
        configurer.setCustomizer(new BeanCustomizer());
        bus.setExtension((Object)configurer, Configurer.class);
    }

    protected void initializeBus(Bus bus) {
        super.initializeBus(bus);
        ResourceManager resourceManager = (ResourceManager)bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)JBossWSResourceInjectionResolver.getInstance());
        SecurityProviderConfig.setup(bus);
    }

    void registerAppContextLifeCycleListener(Bus bus, BusApplicationContext bac) {
        BusLifeCycleManager lm = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        if (null != lm) {
            lm.registerLifeCycleListener((BusLifeCycleListener)new BusApplicationContextLifeCycleListener(bac));
        }
    }

    static class BusApplicationContextLifeCycleListener
    implements BusLifeCycleListener {
        private BusApplicationContext bac;

        BusApplicationContextLifeCycleListener(BusApplicationContext b) {
            this.bac = b;
        }

        public void initComplete() {
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            this.bac.close();
        }
    }
}

