/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.httpserver;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jaxws_spi.HttpHandlerImpl;
import org.apache.cxf.transport.http_jaxws_spi.JAXWSHttpSpiDestination;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.ws.httpserver_httpspi.HttpExchangeDelegate;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngine;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngineFactory;

public class HttpServerDestination
extends JAXWSHttpSpiDestination {
    static final Logger LOG = LogUtils.getL7dLogger(HttpServerDestination.class);
    private static final long serialVersionUID = 1L;
    private HttpServerEngineFactory serverEngineFactory = this.getServerEngineFactory();
    private HttpServerEngine engine;
    private URL url;

    public HttpServerDestination(Bus b, DestinationRegistry registry, EndpointInfo ei) throws IOException {
        super(b, registry, ei);
        HttpServerDestination.getAddressValue((EndpointInfo)ei, (boolean)true);
        this.url = new URL(ei.getAddress());
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void finalizeConfig() {
        this.engine = this.serverEngineFactory.retrieveHttpServerEngine(this.url.getPort());
        if (this.engine == null) {
            try {
                this.engine = this.serverEngineFactory.createHttpServerEngine(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.url.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.url + "\"");
        }
    }

    protected HttpServerEngineFactory getServerEngineFactory() {
        HttpServerEngineFactory serverEngineFactory = (HttpServerEngineFactory)this.getBus().getExtension(HttpServerEngineFactory.class);
        if (serverEngineFactory == null) {
            serverEngineFactory = new HttpServerEngineFactory(this.bus);
        }
        return serverEngineFactory;
    }

    protected void activate() {
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        String addr = this.endpointInfo.getAddress();
        try {
            new URL(addr);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addHandler(addr, new Handler(this, Thread.currentThread().getContextClassLoader()));
    }

    protected void deactivate() {
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeHandler(this.endpointInfo.getAddress());
    }

    class Handler
    extends HttpHandlerImpl
    implements HttpHandler {
        private ClassLoader classLoader;

        public Handler(JAXWSHttpSpiDestination destination, ClassLoader classLoader) {
            super(destination);
            this.classLoader = classLoader;
        }

        public void handle(HttpExchange ex) throws IOException {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.handle((javax.xml.ws.spi.http.HttpExchange)new HttpExchangeDelegate(ex));
            }
            catch (Exception e) {
                LOG.throwing(Handler.class.getName(), "handle(" + HttpExchange.class.getName() + " ex)", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
    }
}

