/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import org.jboss.wsf.common.reflection.AbstractClassProcessor;
import org.jboss.wsf.common.reflection.AnnotationAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedClassProcessor<AO extends AccessibleObject, A extends Annotation>
extends AbstractClassProcessor<AO>
implements AnnotationAware<A> {
    private final Class<A> annotationClass;

    public AbstractAnnotatedClassProcessor(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("annotation class cannot be null");
        }
        this.annotationClass = annotationClass;
    }

    @Override
    public boolean matches(AO accessibleObject) {
        return ((AccessibleObject)accessibleObject).isAnnotationPresent(this.getAnnotation());
    }

    @Override
    public Class<A> getAnnotation() {
        return this.annotationClass;
    }
}

