/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.management.recording;

import java.util.Stack;
import org.jboss.logging.Logger;

public class RecordGroupAssociation {
    private static ThreadLocal<Stack<String>> groupIDAssoc = new ThreadLocal();
    private static Logger log = Logger.getLogger(RecordGroupAssociation.class);

    public static void pushGroupID(String groupID) {
        Stack<String> stack;
        if (log.isDebugEnabled()) {
            log.debug((Object)("pushGroupID: " + groupID + " (Thread " + Thread.currentThread().getName() + ")"));
        }
        if ((stack = groupIDAssoc.get()) == null) {
            stack = new Stack();
            groupIDAssoc.set(stack);
        }
        stack.push(groupID);
    }

    public static String peekGroupID() {
        String groupID = null;
        Stack<String> stack = groupIDAssoc.get();
        if (stack != null && !stack.isEmpty()) {
            groupID = stack.peek();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("peekGroupID: " + groupID + " (Thread " + Thread.currentThread().getName() + ")"));
        }
        return groupID;
    }

    public static String popGroupID() {
        String groupID = null;
        Stack<String> stack = groupIDAssoc.get();
        if (stack != null && !stack.isEmpty()) {
            groupID = stack.pop();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("popGroupID: " + groupID + " (Thread " + Thread.currentThread().getName() + ")"));
        }
        return groupID;
    }
}

