/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.jboss.ws.plugins.tools.MavenLogStreamConsumer;
import org.jboss.ws.plugins.tools.WSContractConsumerParams;
import org.jboss.ws.plugins.tools.WSContractProviderParams;

public class WSContractDelegate {
    private static final PrintStream PS = System.out;
    private Log log;

    public WSContractDelegate(Log log) {
        this.log = log;
    }

    public void runProvider(WSContractProviderParams params) throws Exception {
        if (params.isFork()) {
            this.runProviderOutOfProcess(params);
        } else {
            this.runProviderInProcess(params);
        }
    }

    private void runProviderInProcess(WSContractProviderParams params) throws Exception {
        URLClassLoader loader = params.getLoader();
        Class<?> providerClass = loader.loadClass("org.jboss.ws.api.tools.WSContractProvider");
        Object provider = providerClass.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
        WSContractDelegate.setupProvider(providerClass, provider, params);
        Method m = providerClass.getMethod("provide", String.class);
        m.invoke(provider, params.getEndpointClass());
    }

    private void runProviderOutOfProcess(WSContractProviderParams params) throws Exception {
        MavenLogStreamConsumer err;
        MavenLogStreamConsumer out;
        int result;
        List<String> commandList = WSContractDelegate.initCommandList(params.getArgLine(), params.getManifestOnlyJar(), "org.jboss.ws.tools.cmd.WSProvide");
        String commandLine = WSContractDelegate.getProviderCommandLine(commandList, params);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Running command line: " + commandLine));
        }
        if ((result = CommandLineUtils.executeCommandLine((Commandline)new Commandline(commandLine), (StreamConsumer)(out = new MavenLogStreamConsumer(this.log, MavenLogStreamConsumer.Type.OUTPUT)), (StreamConsumer)(err = new MavenLogStreamConsumer(this.log, MavenLogStreamConsumer.Type.ERROR)))) != 0) {
            throw new Exception("Process terminated with code " + result);
        }
    }

    public void runConsumer(WSContractConsumerParams params, String wsdl) throws Exception {
        if (params.isFork()) {
            this.runConsumerOutOfProcess(params, wsdl);
        } else {
            this.runConsumerInProcess(params, wsdl);
        }
    }

    private void runConsumerInProcess(WSContractConsumerParams params, String wsdl) throws Exception {
        URLClassLoader loader = params.getLoader();
        Class<?> consumerClass = loader.loadClass("org.jboss.ws.api.tools.WSContractConsumer");
        Object consumer = consumerClass.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
        WSContractDelegate.setupConsumer(consumerClass, consumer, params);
        Method m = consumerClass.getMethod("consume", String.class);
        m.invoke(consumer, wsdl);
    }

    private void runConsumerOutOfProcess(WSContractConsumerParams params, String wsdl) throws Exception {
        MavenLogStreamConsumer err;
        MavenLogStreamConsumer out;
        int result;
        List<String> commandList = WSContractDelegate.initCommandList(params.getArgLine(), params.getManifestOnlyJar(), "org.jboss.ws.tools.cmd.WSConsume");
        String commandLine = WSContractDelegate.getConsumerCommandLine(commandList, params, wsdl);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Running command line: " + commandLine));
        }
        if ((result = CommandLineUtils.executeCommandLine((Commandline)new Commandline(commandLine), (StreamConsumer)(out = new MavenLogStreamConsumer(this.log, MavenLogStreamConsumer.Type.OUTPUT)), (StreamConsumer)(err = new MavenLogStreamConsumer(this.log, MavenLogStreamConsumer.Type.ERROR)))) != 0) {
            throw new Exception("Process terminated with code " + result);
        }
    }

    private static List<String> initCommandList(String argLine, File manifestOnlyJar, String toolClass) throws Exception {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("java");
        if (argLine != null) {
            commandList.add(argLine);
        }
        commandList.add("-classpath ");
        commandList.add(manifestOnlyJar.getCanonicalPath());
        commandList.add(toolClass);
        return commandList;
    }

    private static String getConsumerCommandLine(List<String> commandList, WSContractConsumerParams params, String wsdl) {
        List<String> bindingFiles = params.getBindingFiles();
        if (bindingFiles != null && !bindingFiles.isEmpty()) {
            commandList.add("-b");
            commandList.addAll(bindingFiles);
        }
        if (params.isGenerateSource()) {
            commandList.add("-k");
        }
        if (params.getCatalog() != null) {
            commandList.add("-c");
            commandList.add(params.getCatalog().getAbsolutePath());
        }
        if (params.getTargetPackage() != null) {
            commandList.add("-p");
            commandList.add(params.getTargetPackage());
        }
        if (params.getWsdlLocation() != null) {
            commandList.add("-w");
            commandList.add(params.getWsdlLocation());
        }
        if (params.getEncoding() != null) {
            commandList.add("-d");
            commandList.add(params.getEncoding());
        }
        if (params.getOutputDirectory() != null) {
            commandList.add("-o");
            commandList.add(params.getOutputDirectory().getAbsolutePath());
        }
        if (params.getSourceDirectory() != null) {
            commandList.add("-s");
            commandList.add(params.getSourceDirectory().getAbsolutePath());
        }
        if (params.getTarget() != null) {
            commandList.add("-t");
            commandList.add(params.getTarget());
        }
        if (params.isExtension()) {
            commandList.add("-e");
        }
        if (params.isNoCompile()) {
            commandList.add("-n");
        }
        if (params.isAdditionalHeaders()) {
            commandList.add("-a");
        }
        commandList.add(wsdl);
        StringBuilder command = new StringBuilder();
        for (String s : commandList) {
            command.append(s);
            command.append(" ");
        }
        return command.toString();
    }

    private static String getProviderCommandLine(List<String> commandList, WSContractProviderParams params) {
        if (params.isGenerateSource()) {
            commandList.add("-k");
        }
        if (params.isGenerateWsdl()) {
            commandList.add("-w");
        }
        if (params.getOutputDirectory() != null) {
            commandList.add("-o");
            commandList.add(params.getOutputDirectory().getAbsolutePath());
        }
        if (params.getSourceDirectory() != null) {
            commandList.add("-s");
            commandList.add(params.getSourceDirectory().getAbsolutePath());
        }
        if (params.getResourceDirectory() != null) {
            commandList.add("-r");
            commandList.add(params.getResourceDirectory().getAbsolutePath());
        }
        if (params.isExtension()) {
            commandList.add("-e");
        }
        if (params.getPortSoapAddress() != null) {
            commandList.add("-a");
            commandList.add(params.getPortSoapAddress());
        }
        commandList.add(params.getEndpointClass());
        StringBuilder command = new StringBuilder();
        for (String s : commandList) {
            command.append(s);
            command.append(" ");
        }
        return command.toString();
    }

    private static void setupConsumer(Class<?> consumerClass, Object consumer, WSContractConsumerParams params) throws Exception {
        WSContractDelegate.callMethod(consumerClass, consumer, "setAdditionalCompilerClassPath", params.getAdditionalCompilerClassPath());
        Method m = consumerClass.getMethod("setMessageStream", PrintStream.class);
        m.invoke(consumer, PS);
        List<String> bindingFiles = params.getBindingFiles();
        if (bindingFiles != null && !bindingFiles.isEmpty()) {
            LinkedList<File> files = new LinkedList<File>();
            for (String bf : bindingFiles) {
                files.add(new File(bf));
            }
            WSContractDelegate.callMethod(consumerClass, consumer, "setBindingFiles", files);
        }
        if (params.getCatalog() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setCatalog", params.getCatalog());
        }
        WSContractDelegate.callMethod(consumerClass, consumer, "setAdditionalHeaders", params.isAdditionalHeaders());
        WSContractDelegate.callMethod(consumerClass, consumer, "setExtension", params.isExtension());
        WSContractDelegate.callMethod(consumerClass, consumer, "setGenerateSource", params.isGenerateSource());
        WSContractDelegate.callMethod(consumerClass, consumer, "setNoCompile", params.isNoCompile());
        if (params.getOutputDirectory() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setOutputDirectory", params.getOutputDirectory());
        }
        if (params.getSourceDirectory() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setSourceDirectory", params.getSourceDirectory());
        }
        if (params.getTarget() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setTarget", params.getTarget());
        }
        if (params.getTargetPackage() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setTargetPackage", params.getTargetPackage());
        }
        if (params.getWsdlLocation() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setWsdlLocation", params.getWsdlLocation());
        }
        if (params.getEncoding() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setEncoding", params.getEncoding());
        }
    }

    private static Object callMethod(Class<?> clazz, Object obj, String name, boolean param) throws Exception {
        Method m = clazz.getMethod(name, Boolean.TYPE);
        return m.invoke(obj, param);
    }

    private static <T> Object callMethod(Class<?> clazz, Object obj, String name, T param) throws Exception {
        Method m = clazz.getMethod(name, param.getClass());
        return m.invoke(obj, param);
    }

    private static Object callMethod(Class<?> clazz, Object obj, String name, List param) throws Exception {
        Method m = clazz.getMethod(name, List.class);
        return m.invoke(obj, param);
    }

    private static void setupProvider(Class<?> providerClass, Object provider, WSContractProviderParams params) throws Exception {
        Method m = providerClass.getMethod("setClassLoader", ClassLoader.class);
        m.invoke(provider, params.getLoader());
        WSContractDelegate.callMethod(providerClass, provider, "setExtension", params.isExtension());
        WSContractDelegate.callMethod(providerClass, provider, "setGenerateSource", params.isGenerateSource());
        WSContractDelegate.callMethod(providerClass, provider, "setGenerateWsdl", params.isGenerateWsdl());
        Method m2 = providerClass.getMethod("setMessageStream", PrintStream.class);
        m2.invoke(provider, PS);
        if (params.getOutputDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setOutputDirectory", params.getOutputDirectory());
        }
        if (params.getResourceDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setResourceDirectory", params.getResourceDirectory());
        }
        if (params.getSourceDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setSourceDirectory", params.getSourceDirectory());
        }
        if (params.getPortSoapAddress() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setPortSoapAddress", params.getPortSoapAddress());
        }
    }
}

