/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.BufferAllocator;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.ReadPropertyAction;
import org.xnio._private.Messages;

public final class ByteBufferSlicePool
implements Pool<ByteBuffer> {
    private static final int LOCAL_LENGTH;
    private final Set<Ref> refSet = Collections.synchronizedSet(new HashSet());
    private final Queue<Slice> sliceQueue;
    private final BufferAllocator<ByteBuffer> allocator;
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int threadLocalQueueSize;
    private final ThreadLocal<ArrayDeque<Slice>> localQueueHolder = new ThreadLocal<ArrayDeque<Slice>>(){

        @Override
        protected ArrayDeque<Slice> initialValue() {
            return new ArrayDeque<Slice>(ByteBufferSlicePool.this.threadLocalQueueSize){

                protected void finalize() {
                    this.remove();
                }
            };
        }

        @Override
        public void remove() {
            ArrayDeque deque = (ArrayDeque)this.get();
            Slice slice = (Slice)deque.poll();
            while (slice != null) {
                ByteBufferSlicePool.this.doFree(slice);
                slice = (Slice)deque.poll();
            }
        }
    };
    private static final AtomicReferenceFieldUpdater<PooledByteBuffer, ByteBuffer> bufferUpdater;

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize, int threadLocalQueueSize) {
        if (bufferSize <= 0) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        if (maxRegionSize < bufferSize) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        this.buffersPerRegion = maxRegionSize / bufferSize;
        this.bufferSize = bufferSize;
        this.allocator = allocator;
        this.sliceQueue = new ConcurrentLinkedQueue<Slice>();
        this.threadLocalQueueSize = threadLocalQueueSize;
    }

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize) {
        this(allocator, bufferSize, maxRegionSize, LOCAL_LENGTH);
    }

    public ByteBufferSlicePool(int bufferSize, int maxRegionSize) {
        this(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, bufferSize, maxRegionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pooled<ByteBuffer> allocate() {
        Slice slice = this.localQueueHolder.get().poll();
        if (slice != null) {
            return new PooledByteBuffer(slice, slice.slice());
        }
        Queue<Slice> sliceQueue = this.sliceQueue;
        slice = sliceQueue.poll();
        if (slice != null) {
            return new PooledByteBuffer(slice, slice.slice());
        }
        Queue<Slice> queue = sliceQueue;
        synchronized (queue) {
            slice = sliceQueue.poll();
            if (slice != null) {
                return new PooledByteBuffer(slice, slice.slice());
            }
            int bufferSize = this.bufferSize;
            int buffersPerRegion = this.buffersPerRegion;
            ByteBuffer region = this.allocator.allocate(buffersPerRegion * bufferSize);
            int idx = bufferSize;
            for (int i = 1; i < buffersPerRegion; ++i) {
                sliceQueue.add(new Slice(region, idx, bufferSize));
                idx += bufferSize;
            }
            Slice newSlice = new Slice(region, 0, bufferSize);
            return new PooledByteBuffer(newSlice, newSlice.slice());
        }
    }

    private void doFree(Slice region) {
        ArrayDeque<Slice> localQueue = this.localQueueHolder.get();
        if (localQueue.size() == LOCAL_LENGTH) {
            this.sliceQueue.add(region);
        } else {
            localQueue.add(region);
        }
    }

    static {
        int val;
        String value = AccessController.doPrivileged(new ReadPropertyAction("xnio.bufferpool.threadlocal.size", "12"));
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            val = 12;
        }
        LOCAL_LENGTH = val;
        bufferUpdater = AtomicReferenceFieldUpdater.newUpdater(PooledByteBuffer.class, ByteBuffer.class, "buffer");
    }

    private static final class QueueThread
    extends Thread {
        private static final ReferenceQueue<ByteBuffer> REFERENCE_QUEUE = new ReferenceQueue();
        private static final QueueThread INSTANCE = new QueueThread();

        private QueueThread() {
            this.setDaemon(true);
            this.setName("Buffer reclamation thread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Ref reference = (Ref)REFERENCE_QUEUE.remove();
                        reference.free();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        static {
            INSTANCE.start();
        }
    }

    private final class Ref
    extends PhantomReference<ByteBuffer> {
        private final Slice region;

        private Ref(ByteBuffer referent, Slice region) {
            super(referent, QueueThread.REFERENCE_QUEUE);
            this.region = region;
        }

        void free() {
            ByteBufferSlicePool.this.doFree(this.region);
            ByteBufferSlicePool.this.refSet.remove(this);
        }
    }

    private final class Slice {
        private final ByteBuffer parent;
        private final int start;
        private final int size;

        private Slice(ByteBuffer parent, int start, int size) {
            this.parent = parent;
            this.start = start;
            this.size = size;
        }

        ByteBuffer slice() {
            return ((ByteBuffer)this.parent.duplicate().position(this.start).limit(this.start + this.size)).slice();
        }
    }

    private final class PooledByteBuffer
    implements Pooled<ByteBuffer> {
        private final Slice region;
        volatile ByteBuffer buffer;

        PooledByteBuffer(Slice region, ByteBuffer buffer) {
            this.region = region;
            this.buffer = buffer;
        }

        @Override
        public void discard() {
            ByteBuffer buffer = bufferUpdater.getAndSet(this, null);
            if (buffer != null) {
                ByteBufferSlicePool.this.refSet.add(new Ref(buffer, this.region));
            }
        }

        @Override
        public void free() {
            if (bufferUpdater.getAndSet(this, null) != null) {
                ByteBufferSlicePool.this.doFree(this.region);
            }
        }

        @Override
        public ByteBuffer getResource() {
            ByteBuffer buffer = this.buffer;
            if (buffer == null) {
                throw Messages.msg.bufferFreed();
            }
            return buffer;
        }

        public String toString() {
            return "Pooled buffer " + this.buffer;
        }
    }
}

