/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.internal.task.api.model.EmailNotificationHeader;

@Entity
@Table(name="email_header")
@SequenceGenerator(name="emailNotificationHeadIdSeq", sequenceName="EMAILNOTIFHEAD_ID_SEQ", allocationSize=1)
public class EmailNotificationHeaderImpl
implements EmailNotificationHeader {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="emailNotificationHeadIdSeq")
    private Long id;
    private String language;
    @Column(name="replyToAddress")
    private String replyTo;
    @Column(name="fromAddress")
    private String from;
    private String subject;
    @Lob
    @Column(length=65535)
    private String body;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.language != null) {
            out.writeBoolean(true);
            out.writeUTF(this.language);
        } else {
            out.writeBoolean(false);
        }
        if (this.subject != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subject);
        } else {
            out.writeBoolean(false);
        }
        if (this.replyTo != null) {
            out.writeBoolean(true);
            out.writeUTF(this.replyTo);
        } else {
            out.writeBoolean(false);
        }
        if (this.from != null) {
            out.writeBoolean(true);
            out.writeUTF(this.from);
        } else {
            out.writeBoolean(false);
        }
        if (this.body != null) {
            out.writeBoolean(true);
            out.writeUTF(this.body);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        if (in.readBoolean()) {
            this.language = in.readUTF();
        }
        if (in.readBoolean()) {
            this.subject = in.readUTF();
        }
        if (in.readBoolean()) {
            this.replyTo = in.readUTF();
        }
        if (in.readBoolean()) {
            this.from = in.readUTF();
        }
        if (in.readBoolean()) {
            this.body = in.readUTF();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailNotificationHeaderImpl)) {
            return false;
        }
        EmailNotificationHeaderImpl other = (EmailNotificationHeaderImpl)obj;
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.replyTo == null ? other.replyTo != null : !this.replyTo.equals(other.replyTo));
    }
}

