/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.internal.task.api.model.InternalI18NText;

@Entity
@Table(name="I18NText")
@SequenceGenerator(name="i18nTextIdSeq", sequenceName="I18NTEXT_ID_SEQ", allocationSize=1)
public class I18NTextImpl
implements InternalI18NText {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="i18nTextIdSeq")
    @Column(name="id")
    private Long id = null;
    private String language;
    private String shortText;
    @Lob
    @Column(length=65535)
    private String text;

    public I18NTextImpl() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.language == null) {
            this.language = "";
        }
        out.writeUTF(this.language);
        if (this.shortText == null) {
            this.shortText = "";
        }
        out.writeUTF(this.shortText);
        if (this.text == null) {
            this.text = "";
        }
        out.writeUTF(this.text);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.language = in.readUTF();
        this.shortText = in.readUTF();
        this.text = in.readUTF();
    }

    public I18NTextImpl(String language, String text) {
        this.language = language;
        this.shortText = text != null && text.length() > 256 ? text.substring(0, 255) : text;
        this.text = text;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.shortText = text != null && text.length() > 256 ? text.substring(0, 255) : text;
        this.text = text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.shortText == null ? 0 : this.shortText.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof I18NTextImpl)) {
            return false;
        }
        I18NTextImpl other = (I18NTextImpl)obj;
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.shortText == null ? other.shortText != null : !this.shortText.equals(other.shortText)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static String getLocalText(List<I18NTextImpl> list, String prefferedLanguage, String defaultLanguage) {
        for (I18NTextImpl text : list) {
            if (!text.getLanguage().equals(prefferedLanguage)) continue;
            return text.getText();
        }
        if (defaultLanguage == null) {
            for (I18NTextImpl text : list) {
                if (!text.getLanguage().equals(defaultLanguage)) continue;
                return text.getText();
            }
        }
        return "";
    }
}

