/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import java.io.Serializable;
import javax.ejb.CreateException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class CommandListenerBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private MessageDrivenContext messageDrivenContext;
    private LocalCommandService commandService;
    private ConnectionFactory jmsConnectionFactory;
    private static final Log log = LogFactory.getLog((Class)CommandListenerBean.class);

    public void onMessage(Message message) {
        try {
            Destination replyTo;
            Object result;
            Command command = this.extractCommand(message);
            if (command == null) {
                return;
            }
            try {
                result = this.commandService.execute(command);
            }
            catch (RuntimeException e) {
                if (DbPersistenceService.isLockingException((Exception)e)) {
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to execute " + command), (Throwable)e);
                } else {
                    log.error((Object)("failed to execute " + command), (Throwable)e);
                }
                this.messageDrivenContext.setRollbackOnly();
                return;
            }
            if (this.jmsConnectionFactory != null && (replyTo = message.getJMSReplyTo()) != null && (result instanceof Serializable || result == null)) {
                this.sendResult((Serializable)result, replyTo, message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            this.messageDrivenContext.setRollbackOnly();
            log.error((Object)("failed to process message " + message), (Throwable)e);
        }
    }

    protected Command extractCommand(Message message) throws JMSException {
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable object = objectMessage.getObject();
            if (object instanceof Command) {
                return (Command)object;
            }
            log.warn((Object)("not a command: " + object));
        } else {
            log.warn((Object)("not an object message: " + message));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResult(Serializable result, Destination destination, String correlationId) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sending " + result + " to " + destination));
        }
        Connection jmsConnection = this.jmsConnectionFactory.createConnection();
        try {
            Session jmsSession = jmsConnection.createSession(false, 1);
            ObjectMessage resultMessage = jmsSession.createObjectMessage(result);
            resultMessage.setJMSCorrelationID(correlationId);
            jmsSession.createProducer(destination).send((Message)resultMessage);
        }
        finally {
            jmsConnection.close();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.messageDrivenContext = messageDrivenContext;
    }

    public void ejbRemove() {
        this.jmsConnectionFactory = null;
        this.commandService = null;
        this.messageDrivenContext = null;
    }

    public void ejbCreate() {
        try {
            InitialContext jndiContext = new InitialContext();
            LocalCommandServiceHome commandServiceHome = (LocalCommandServiceHome)jndiContext.lookup("java:comp/env/ejb/LocalCommandServiceBean");
            this.commandService = commandServiceHome.create();
            try {
                this.jmsConnectionFactory = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/JbpmConnectionFactory");
            }
            catch (NamingException e) {
                log.warn((Object)"error retrieving connection factory, results will not be sent back", (Throwable)e);
            }
            jndiContext.close();
        }
        catch (NamingException e) {
            throw new JbpmException("error retrieving command service home", (Throwable)e);
        }
        catch (CreateException e) {
            throw new JbpmException("failed to create command service", (Throwable)e);
        }
    }
}

