/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.command.CommandService;

public class CommandServiceBean
implements SessionBean,
CommandService {
    private static final long serialVersionUID = 1L;
    private JbpmConfiguration jbpmConfiguration;
    private SessionContext sessionContext;
    private static final Log log = LogFactory.getLog((Class)CommandServiceBean.class);

    public void ejbCreate() throws CreateException {
        String jbpmCfgResource;
        try {
            InitialContext jndiContext = new InitialContext();
            jbpmCfgResource = (String)jndiContext.lookup("java:comp/env/JbpmCfgResource");
        }
        catch (NamingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("could not fetch configuration resource: " + e.getMessage()));
            }
            jbpmCfgResource = null;
        }
        this.jbpmConfiguration = JbpmConfiguration.getInstance((String)jbpmCfgResource);
    }

    public Object execute(Command command) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing " + command));
            }
            Object result = command.execute(jbpmContext);
            if (jbpmContext.getServices().getTxService().isRollbackOnly()) {
                this.sessionContext.setRollbackOnly();
            }
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JbpmException("failed to execute " + command, (Throwable)e);
        }
        finally {
            jbpmContext.close();
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbRemove() {
        this.sessionContext = null;
        this.jbpmConfiguration = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

