/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;

public class ExecuteJobCommand
implements Command {
    private final long jobId;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)ExecuteJobCommand.class.getName());

    public ExecuteJobCommand(long jobId) {
        this.jobId = jobId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        Job job = ExecuteJobCommand.acquireJob(this.jobId, jbpmContext);
        if (job != null) {
            ExecuteJobCommand.executeJob(job, jbpmContext);
        }
        return job;
    }

    static Job acquireJob(long jobId, JbpmContext jbpmContext) {
        Job job;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("acquiring job: " + jobId));
        }
        if ((job = jbpmContext.getJobSession().getJob(jobId)) != null) {
            ProcessInstance processInstance = job.getProcessInstance();
            jbpmContext.addAutoSaveProcessInstance(processInstance);
            if (job.isExclusive()) {
                jbpmContext.getGraphSession().lockProcessInstance(processInstance);
            }
            job.setLockOwner(Thread.currentThread().getName());
            if (debug) {
                log.debug((Object)("acquired " + job));
            }
        } else if (debug) {
            log.debug((Object)("job not found: " + jobId));
        }
        return job;
    }

    static void executeJob(Job job, JbpmContext jbpmContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing " + job));
        }
        if (job.execute(jbpmContext)) {
            jbpmContext.getJobSession().deleteJob(job);
        }
    }
}

