/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.msg.MessageService;
import org.jbpm.msg.jms.JmsMessageServiceFactory;
import org.jbpm.svc.Services;

public class JmsMessageService
implements MessageService {
    private final JmsMessageServiceFactory serviceFactory;
    private final Connection connection;
    private final Session session;
    private static final long serialVersionUID = 2L;
    private static final String GROUP_ID_PROP = "JMSXGroupID";
    private static final String GROUP_PREFIX = "jBPMPID";

    public JmsMessageService(Connection connection, Destination destination, boolean commitEnabled) throws JMSException {
        this.connection = connection;
        this.session = JmsMessageService.createSession(connection);
        this.serviceFactory = (JmsMessageServiceFactory)Services.getCurrentService((String)"message");
    }

    public JmsMessageService(JmsMessageServiceFactory serviceFactory) throws JMSException {
        this.connection = serviceFactory.getConnectionFactory().createConnection();
        this.session = JmsMessageService.createSession(this.connection);
        this.serviceFactory = serviceFactory;
    }

    private static Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    public void send(Job job) {
        this.getJobSession().saveJob(job);
        try {
            this.sendMessage(job);
        }
        catch (JMSException e) {
            throw new JbpmException("could not send jms message", (Throwable)e);
        }
    }

    private JobSession getJobSession() {
        return this.serviceFactory.getJbpmConfiguration().getCurrentJbpmContext().getJobSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Job job) throws JMSException {
        Message message = this.getSession().createMessage();
        this.modifyMessage(message, job);
        MessageProducer messageProducer = this.getMessageProducer();
        try {
            messageProducer.send(message);
        }
        finally {
            messageProducer.close();
        }
    }

    protected void modifyMessage(Message message, Job job) throws JMSException {
        message.setLongProperty("jobId", job.getId());
        if (job.isExclusive()) {
            message.setStringProperty(GROUP_ID_PROP, GROUP_PREFIX + job.getProcessInstance().getId());
        }
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            throw new JbpmException("could not close jms connection", (Throwable)e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    protected MessageProducer getMessageProducer() throws JMSException {
        return this.getSession().createProducer(this.serviceFactory.getDestination());
    }
}

