/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.msg.jms.JmsMessageService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.JndiUtil;

public class JmsMessageServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    String connectionFactoryJndiName = "java:comp/env/jms/JbpmConnectionFactory";
    String destinationJndiName = "java:comp/env/jms/JobQueue";
    private JbpmConfiguration jbpmConfiguration;
    private ConnectionFactory connectionFactory;
    private Destination destination;

    public JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            if (jbpmContext == null) {
                throw new JbpmException("no active jbpm context");
            }
            this.jbpmConfiguration = jbpmContext.getJbpmConfiguration();
        }
        return this.jbpmConfiguration;
    }

    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)JndiUtil.lookup((String)this.connectionFactoryJndiName, (Class)ConnectionFactory.class);
        }
        return this.connectionFactory;
    }

    public synchronized Destination getDestination() {
        if (this.destination == null) {
            this.destination = (Destination)JndiUtil.lookup((String)this.destinationJndiName, (Class)Destination.class);
        }
        return this.destination;
    }

    public boolean isCommitEnabled() {
        return false;
    }

    public Service openService() {
        try {
            return new JmsMessageService(this);
        }
        catch (JMSException e) {
            throw new JbpmException("could not open message service", (Throwable)e);
        }
    }

    public void close() {
        this.connectionFactory = null;
        this.destination = null;
    }
}

