/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.scheduler.ejbtimer.LocalTimerService;
import org.jbpm.scheduler.ejbtimer.LocalTimerServiceHome;

public class EjbSchedulerService
implements SchedulerService {
    private static final long serialVersionUID = 2L;
    private JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
    private LocalTimerService timerService;
    private static final Log log = LogFactory.getLog((Class)EjbSchedulerService.class);

    public EjbSchedulerService(LocalTimerServiceHome timerServiceHome) {
        if (this.jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
        try {
            this.timerService = timerServiceHome.create();
        }
        catch (CreateException e) {
            throw new JbpmException("failed to create local timer service", (Throwable)e);
        }
    }

    public void createTimer(Timer timer) {
        log.debug((Object)("creating " + timer));
        this.jbpmContext.getJobSession().saveJob((Job)timer);
        this.jbpmContext.getSession().flush();
        this.timerService.createTimer(timer);
    }

    public void deleteTimer(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting " + timer));
        }
        this.timerService.cancelTimer(timer);
        this.jbpmContext.getJobSession().deleteJob((Job)timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting timers by name '" + timerName + "' for " + token));
        }
        this.timerService.cancelTimersByName(timerName, token);
        this.jbpmContext.getJobSession().deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting timers for " + processInstance));
        }
        this.timerService.cancelTimersForProcessInstance(processInstance);
        this.jbpmContext.getJobSession().deleteJobsForProcessInstance(processInstance);
    }

    public void close() {
        try {
            this.timerService.remove();
        }
        catch (RemoveException e) {
            throw new JbpmException("ejb local timer service close problem", (Throwable)e);
        }
    }
}

